package com.biz.crm.mdm.business.dictionary.local.deprecated;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.deprecated.model.PageResult;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.sdk.deprecated.dto.MdmDictTypeReqVo;
import com.biz.crm.mdm.business.dictionary.sdk.deprecated.vo.*;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictTypeDto;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictTypeVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

/**
 * 数据字典类型表
 *
 * @author pengxi
 */
@Slf4j
@RestController
@RequestMapping("/mdmdicttype")
@Api(tags = "MDM-数据字典分类")
@Deprecated
public class MdmDictTypeController {
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private DictTypeVoService dictTypeVoService;

  private DictTypeDto transDto(MdmDictTypeReqVo reqVo) {
    return this.nebulaToolkitService.copyObjectByWhiteList(reqVo, DictTypeDto.class, HashSet.class, ArrayList.class);
  }

  @ApiOperation(value = "查询列表（分页）")
  @PostMapping("/list")
  public Result<PageResult<MdmDictTypeRespVo>> list(@PageableDefault(50) Pageable pageable, @RequestBody MdmDictTypeReqVo reqVo) {
    try {
      Page<DictTypeVo> result = dictTypeVoService.findByConditions(pageable, this.transDto(reqVo));
      List<MdmDictTypeRespVo> voList = Lists.newLinkedList();
      if (result.getCurrent() > 0) {
        voList = (List<MdmDictTypeRespVo>) this.nebulaToolkitService.copyCollectionByWhiteList(result.getRecords(), DictTypeVo.class, MdmDictTypeRespVo.class, HashSet.class, ArrayList.class);
      }
      return Result.ok(PageResult.<MdmDictTypeRespVo>builder()
          .data(voList)
          .count(result.getTotal())
          .build());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "详情", httpMethod = "GET", notes = "只查询数据字典类型")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
      @ApiImplicitParam(name = "dictTypeCode", value = "字典类型编码", required = false, dataType = "String", paramType = "query")
  })
  @GetMapping("/query")
  public Result<MdmDictTypeRespVo> query(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "dictTypeCode", required = false) String dictTypeCode) {
    DictTypeVo vo = null;
    if (StringUtils.isNotBlank(id)) {
      vo = dictTypeVoService.findById(id);
    } else if (StringUtils.isNotBlank(dictTypeCode)) {
      vo = dictTypeVoService.findByDictTypeCode(dictTypeCode);
    } else {
      return Result.error("ID或字段类型不能同时为空");
    }
    if (Objects.isNull(vo)) {
      return Result.error("未获取到相应信息");
    }
    MdmDictTypeRespVo respVo = this.nebulaToolkitService.copyObjectByWhiteList(vo, MdmDictTypeRespVo.class, HashSet.class, ArrayList.class);
    return Result.ok(respVo);
  }

  @ApiOperation(value = "新增")
  @PostMapping("/save")
  public Result save(@RequestBody MdmDictTypeReqVo reqVo) {
    try {
      dictTypeVoService.save(this.transDto(reqVo));
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PostMapping("/update")
  public Result update(@RequestBody MdmDictTypeReqVo reqVo) {
    try {
      dictTypeVoService.update(this.transDto(reqVo));
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "删除", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/delete")
  public Result delete(@RequestBody List<String> ids) {
    try {
      dictTypeVoService.deleteBatch(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "清除全部缓存", httpMethod = "POST")
  @PostMapping("/deleteAllCache")
  public Result deleteAllCache() {
    // TODO 缓存后续完善
    //dictTypeService.deleteAllCache();
    return Result.ok("删除成功");
  }

  @ApiOperation(value = "根据id集合批量删除缓存", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/deleteCacheByIds")
  public Result deleteCacheByIds(@RequestBody List<String> ids) {
    // TODO 缓存后续完善
    //dictTypeService.deleteCacheByIds(ids);
    return Result.ok("删除成功");
  }

  @ApiOperation(value = "根据字典类型编码集合批量删除缓存", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "codeList", value = "类型编码集合", required = true, paramType = "body")
  })
  @PostMapping("/deleteCacheByCodeList")
  public Result deleteCacheByCodeList(@RequestBody List<String> codeList) {
    // TODO 缓存后续完善
    //dictTypeService.deleteCacheByCodeList(codeList);
    return Result.ok("删除成功");
  }

  @PostMapping("/getDictGroupRedisList")
  @ApiOperation("请勿调用，字典工具类查询构建缓存数据")
  public Result<List<DictGroupRedisVo>> getDictGroupRedisList(@RequestBody List<String> dictTypeCodeList) {
    // TODO 缓存后续完善
    //List<DictGroupRedisVo> list = dictTypeService.getDictGroupRedisList(dictTypeCodeList);
    return Result.ok(new ArrayList<>());
  }

  @ApiOperation("仅数据同步查询使用")
  @PostMapping("/obtainSyncList")
  public Result<MdmDictEngineSyncVo> obtainSyncList(@RequestBody MdmSyncStandardDictReqVo mdmSyncStandardDictReqVo) {
    // TODO 缓存后续完善
    //MdmDictEngineSyncVo syncVo = dictTypeService.obtainSyncList(mdmSyncStandardDictReqVo);
    return Result.ok(new MdmDictEngineSyncVo());
  }
}
