package com.biz.crm.mdm.business.dictionary.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 数据字典扩展字段配置表实体类
 *
 * @author Tao.Chen
 * @date 2020-11-20 15:00:54
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "mdm_dict_attr_conf")
@TableName(value = "mdm_dict_attr_conf")
@org.hibernate.annotations.Table(appliesTo = "mdm_dict_attr_conf", comment = "数据字典扩展字段配置表实体类")
public class DictAttrConfEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = -3860388806700179472L;

  @TableField(value = "dict_type_code")
  @Column(name = "dict_type_code", nullable = false, columnDefinition = "varchar(64) COMMENT '数据字典类型编码'")
  private String dictTypeCode;

  @TableField(value = "field_code")
  @Column(name = "field_code", nullable = false, columnDefinition = "varchar(64) COMMENT '字段编码'")
  private String fieldCode;

  @TableField(value = "field_name")
  @Column(name = "field_name", nullable = false, columnDefinition = "varchar(64) COMMENT '字段显示名称'")
  private String fieldName;

  @TableField(value = "ext_filed")
  @Column(name = "ext_filed", nullable = false, columnDefinition = "varchar(32) COMMENT '对应data表扩展字段'")
  private String extField;

  @TableField(value = "required")
  @Column(name = "required", nullable = false, columnDefinition = "varchar(4) COMMENT '是否必填 0否 1是'")
  private Integer required;

  @TableField(value = "show_order")
  @Column(name = "show_order", nullable = false, columnDefinition = "varchar(4) COMMENT '显示顺序'")
  private String showOrder;

  @TableField(value = "select_single_only")
  @Column(name = "select_single_only", nullable = true, columnDefinition = "varchar(64) COMMENT '下拉框单选限制：1 是；0 否'")
  private String selectSingleOnly;

  @TableField(value = "select_dict_type_code")
  @Column(name = "select_dict_type_code", nullable = true, columnDefinition = "varchar(64) COMMENT '下拉框数据字典'")
  private String selectDictTypeCode;

}
