package com.biz.crm.mdm.business.dictionary.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 数据字典明细表事件引擎事件通知Dto
 *
 * @author pengxi
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DictDataNebulaEventDto", description = "数据字典明细表事件引擎事件通知Dto")
public class DictDataNebulaEventDto extends TenantDto implements NebulaEventDto {

  @ApiModelProperty("字典编码")
  private String dictCode;

  @ApiModelProperty("字典名称")
  private String dictValue;

  @ApiModelProperty("字典描述")
  private String dictDesc;

  @ApiModelProperty("字典类型编码")
  private String dictTypeCode;

  @ApiModelProperty("排序")
  private Integer dictSort;

  @ApiModelProperty("上级字典编码")
  private String parentDictCode;
}