package com.biz.crm.mdm.business.dictionary.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 数据字典类型列表(包含明细)
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.29 17:38
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DictTypeContainDataDto", description = "数据字典类型表(包含明细)")
public class DictTypeContainDataDto extends TenantDto {
    @ApiModelProperty("页码")
    private Integer page;
    @ApiModelProperty("每页大小")
    private Integer size;
    @ApiModelProperty("字典类型编码")
    private String dictTypeCode;

    @ApiModelProperty("字典类型所属模块")
    private String dictTypeModule;

}