package com.biz.crm.mdm.business.dictionary.sdk.service;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictDataDto;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;


import java.util.List;
import java.util.Map;

/**
 * 数据字典明细表接口
 *
 * @author pengxi
 */
public interface DictDataVoService {

  /**
   * 根据dictTypeCode获取字段数据列表
   *
   * @param dictTypeCode 字典类型编码
   * @return
   */
  List<DictDataVo> findByDictTypeCode(String dictTypeCode);

  /**
   * 获取字典下级列表
   *
   * @param dictTypeCode 字典类型编码
   * @param parentDictCode 上级字典值
   * @return List<DictDataVo>
   */
  List<DictDataVo> findDictLowerByDictTypeCode(String dictTypeCode,String parentDictCode);

  /**
   * 根据dictTypeCode获取树形结构
   *
   * @param dictTypeCode 字典类型
   * @return
   */
  List<DictDataVo> findTreeByDictTypeCode(String dictTypeCode);

  /**
   * 查询详情
   *
   * @param id ID主键
   * @return
   */
  DictDataVo findById(String id);

  /**
   * 根据字典类型和字典编码查询详情
   *
   * @param dictTypeCode 字典类型
   * @param dictCode     字典编码
   * @return
   */
  DictDataVo findByDictTypeCodeAndDictCode(String dictTypeCode, String dictCode);

  /**
   * 批量获取数据字典下拉框
   *
   * @param dictTypeCodeList 字典类型集合
   * @return
   */
  Map<String, List<DictDataVo>> findByDictTypeCodeList(List<String> dictTypeCodeList);

  /**
   * 获取包含扩展信息（属性设置）的字典列表
   *
   * @param dto
   * @return
   */
  List<JSONObject> findContainExtendByConditions(DictDataDto dto);

  /**
   * 新增
   *
   * @param dto
   * @return
   */
  void save(DictDataDto dto);

  /**
   * 更新
   *
   * @param dto
   */
  void update(DictDataDto dto);

  /**
   * 删除
   *
   * @param ids ID集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 启用
   *
   * @param ids ID集合
   */
  void enableBatch(List<String> ids);

  /**
   * 禁用
   *
   * @param ids ID集合
   */
  void disableBatch(List<String> ids);

  /**
   * 根据字典类型删除
   *
   * @param dictTypeCode 字段类型
   */
  void deleteByDictTypeCode(String dictTypeCode);

  /**
   * 移除明细表指定扩展字段的值
   *
   * @param dictTypeCode 字典类型编码
   * @param extList      扩展字段
   */
  void deleteExtFieldVal(String dictTypeCode, List<String> extList);

}

