package com.biz.crm.mdm.business.dictionary.sdk.service;

import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;

import java.util.List;
import java.util.Map;

/**
 * TODO 用来替代：com.biz.crm.util.DictUtil
 *
 * @author hefan
 */
public interface DictToolkitService {

    /**
     * 根据字典类型编码获取字典数据
     *
     * @param dictTypeCode 字典类型编码
     * @return List
     */
    List<DictDataVo> tree(String dictTypeCode);

    /**
     * 根据字典类型编码获取字典数据(code,value)
     *
     * @param dictTypeCode 字典类型编码
     * @return Map
     */
    Map<String, String> findMapByDictTypeCode(String dictTypeCode);

    /**
     * 根据字典类型编码获取字典数据(value,code)
     *
     * @param dictTypeCode 字典类型编码
     * @return Map
     */
    Map<String, String> findConvertMapByDictTypeCode(String dictTypeCode);
}
