package com.biz.crm.mdm.business.dictionary.sdk.event;

import com.biz.crm.mdm.business.dictionary.sdk.dto.DictDataNebulaEventBatchDto;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictDataNebulaEventDto;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictDataNebulaEventUpdateDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 字典事件引擎批量事件通知Dto
 *
 * @author pengxi
 */
public interface DictDataNebulaEventListener extends NebulaEvent {

  /**
   * 当字典信息创建时触发
   *
   * @param dictDataNebulaEventDto 创建时的vo
   */
  void onCreate(DictDataNebulaEventDto dictDataNebulaEventDto);

  /**
   * 当字典信息修改时触发
   *
   * @param dictDataNebulaEventUpdateDto
   */
  void onUpdate(DictDataNebulaEventUpdateDto dictDataNebulaEventUpdateDto);

  /**
   * 当字典信息禁用时触发
   *
   * @param dictDataNebulaEventBatchDto 禁用vo信息
   */
  void onDisable(DictDataNebulaEventBatchDto dictDataNebulaEventBatchDto);

  /**
   * 当字典信息启用时触发
   *
   * @param dictDataNebulaEventBatchDto 禁用vo信息
   */
  void onEnable(DictDataNebulaEventBatchDto dictDataNebulaEventBatchDto);

  /**
   * 当字典信息删除时触发
   *
   * @param dictDataNebulaEventBatchDto 删除vo信息
   */
  void onDelete(DictDataNebulaEventBatchDto dictDataNebulaEventBatchDto);
}
