package com.biz.crm.mdm.business.dictionary.sdk.event;

import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;

import java.util.List;

/**
 * DictDataEventListener 字典数据操作事件通知
 *
 * @author pengxi
 */
public interface DictDataEventListener {

  /**
   * 当创建时，触发事件
   *
   * @param vo
   * @return
   */
  void onCreate(DictDataVo vo);


  /**
   * 当删除时，触发事件
   *
   * @param vos
   * @return
   */
  void onDelete(List<DictDataVo> vos);

  /**
   * 当启用时，触发事件
   *
   * @param vos
   * @return
   */
  void onEnable(List<DictDataVo> vos);

  /**
   * 当禁用时，触发事件
   *
   * @param vos
   * @return
   */
  void onDisable(List<DictDataVo> vos);

  /**
   * 当修改时，触发事件
   *
   * @param oldVo
   * @param newVo
   * @return
   */
  void onChange(DictDataVo oldVo, DictDataVo newVo);

}
