package com.biz.crm.mdm.business.dictionary.sdk.service;

import com.biz.crm.mdm.business.dictionary.sdk.dto.DictAttrConfDto;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictAttrConfVo;

import java.util.List;

/**
 * 数据字典扩展字段配置表接口
 *
 * @author pengxi
 */
public interface DictAttrConfVoService {

  /**
   * 列表
   *
   * @param dictTypeCode
   * @return
   */
  List<DictAttrConfVo> findByDictTypeCode(String dictTypeCode);

  /**
   * 查询
   *
   * @param id
   * @return
   */
  DictAttrConfVo findById(String id);

  /**
   * 新增
   *
   * @param reqVo
   * @return
   */
  void save(DictAttrConfDto reqVo);

  /**
   * 更新
   *
   * @param reqVo
   */
  void update(DictAttrConfDto reqVo);

  /**
   * 删除
   *
   * @return
   */
  void deleteBatch(List<String> ids);

  /**
   * 根据字典类型编码删除扩展字段配置
   *
   * @param dictTypeCode
   */
  void deleteByDictTypeCode(String dictTypeCode);

}

