package com.biz.crm.mdm.business.dictionary.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 数据字典扩展字段配置表返回vo
 *
 * @author pengxi
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "数据字典扩展字段配置表")
public class DictAttrConfVo extends TenantFlagOpVo {
  
  private static final long serialVersionUID = -8493729943944221762L;

  @ApiModelProperty("数据字典类型编码")
  private String dictTypeCode;

  @ApiModelProperty("字段编码")
  private String fieldCode;

  @ApiModelProperty("字段显示名称")
  private String fieldName;

  @ApiModelProperty("对应data表扩展字段")
  private String extField;

  @ApiModelProperty("是否必填 0否 1是")
  private Integer required;

  @ApiModelProperty("显示顺序")
  private String showOrder;

  @ApiModelProperty("数据源字典")
  private String selectDictTypeCode;

  @ApiModelProperty("下拉框单选限制，1单选，0多选")
  private String selectSingleOnly;
}