package com.biz.crm.mdm.business.dictionary.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 数据字典明细表返回vo
 *
 * @author pengxi
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "数据字典明细表")
public class DictDataVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty("字典编码")
  private String dictCode;

  @ApiModelProperty("字典名称")
  private String dictValue;

  @ApiModelProperty("字典描述")
  private String dictDesc;

  @ApiModelProperty("字典类型编码")
  private String dictTypeCode;

  @ApiModelProperty("排序")
  private Integer dictSort;

  @ApiModelProperty("路径,查询时生成的")
  private String path;

  @ApiModelProperty("上级字典编码")
  private String parentDictCode;

  @ApiModelProperty("是否展开树的下级 true-展开 false-不展开")
  private Boolean open = false;

  @ApiModelProperty("下级")
  private List<DictDataVo> children;

  @ApiModelProperty(value = "扩展字段map")
  private Map<String, String> extendMap = new HashMap<>(16);

  @ApiModelProperty(value = "外部明细id")
  private String externalDetailId;

  @ApiModelProperty(value = "外部字典id")
  private String externalDataDictId;

}