package com.biz.crm.mdm.business.fiscal.year.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.fiscal.year.feign.feign.FiscalYearVoServiceFeign;
import com.biz.crm.mdm.business.fiscal.year.sdk.vo.FiscalYearVo;
import org.springframework.stereotype.Component;
import feign.hystrix.FallbackFactory;
import java.util.Date;
import java.util.List;

/**
 * @description: 企业财年
 * @author: rentao
 * @date: 2022/4/11 21:20
 */
@Component
public class FiscalYearVoServiceFeignImpl implements FallbackFactory<FiscalYearVoServiceFeign> {

  @Override
  public FiscalYearVoServiceFeign create(Throwable throwable) {
    return new FiscalYearVoServiceFeign() {
      @Override
      public Result<List<FiscalYearVo>> findByBeginTimeAndEndTime(Date beginTime, Date endTime) {
        throw new UnsupportedOperationException("根据时间查询财年信息详情熔断");

      }
    };
  }
}
