package com.biz.crm.mdm.business.fiscal.year.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.fiscal.year.local.entity.FiscalYearEntity;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearLinkageDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearPageDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.vo.FiscalYearVo;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 财年表的mybatis-plus接口类 {@link FiscalYearEntity}
 *
 * @author ning.zhang
 * @date 2021-11-16 14:08:28
 */
public interface FiscalYearMapper extends BaseMapper<FiscalYearEntity> {

  /**
   * 财年分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<FiscalYearEntity> findByConditions(Page<FiscalYearEntity> page, @Param("dto") FiscalYearPageDto dto);

  /**
   * 财年联动查询
   *
   * @param dto 请求dto
   * @return 财年信息
   */
  FiscalYearEntity findByFiscalYearLinkageDto(@Param("dto") FiscalYearLinkageDto dto);

  /**
   * 通过ID查询财年信息
   * @param id
   * @return
   */
  FiscalYearEntity findById(@Param("id") String id);

  /**
   * 财年联动查询 财年集合
   * @param dto
   * @return
   */
  List<FiscalYearEntity> findByFiscalYearLinkageYearDto(@Param("dto") FiscalYearLinkageDto dto);

  /**
   * 根据时间查询财年信息
   * @param beginTime
   * @param endTime
   * @param tenantCode
   * @return
   */
  List<FiscalYearVo> findByBeginTimeAndEndTime(@Param("beginTime") Date beginTime, @Param("endTime") Date endTime, @Param("tenantCode") String tenantCode);
}

