package com.biz.crm.mdm.business.fiscal.year.local.service.internal;

import com.biz.crm.mdm.business.fiscal.year.local.entity.FiscalYearDetailEntity;
import com.biz.crm.mdm.business.fiscal.year.local.repository.FiscalYearDetailRepository;
import com.biz.crm.mdm.business.fiscal.year.local.service.FiscalYearDetailService;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearDetailDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.mdm.business.fiscal.year.local.service.internal
 * @ClassName FiscalYearDetailServiceImpl
 * @Author YangWei
 * @Date 2022/2/28 下午4:42
 * @Description 财年明细接口实现
 */
@Slf4j
@Service("fiscalYearDetailService")
public class FiscalYearDetailServiceImpl implements FiscalYearDetailService {

  @Autowired(required = false)
  private FiscalYearDetailRepository fiscalYearDetailRepository;

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public void batchCreate(List<FiscalYearDetailDto> fiscalYearDetailDtos, String year, String tenantCode) {
    List<FiscalYearDetailEntity> entities = fiscalYearDetailDtos.stream()
        .map(dto -> {
          FiscalYearDetailEntity entity = this.nebulaToolkitService
              .copyObjectByWhiteList(dto, FiscalYearDetailEntity.class, HashSet.class, ArrayList.class);
          entity.setYear(year);
          entity.setTenantCode(tenantCode);
          return entity;
        }).collect(Collectors.toList());
    this.fiscalYearDetailRepository.saveBatch(entities);
  }

  @Override
  public void batchUpdate(List<FiscalYearDetailDto> fiscalYearDetailDtos, String year, String tenantCode) {
    //删除原明细
    this.fiscalYearDetailRepository.deleteByYear(year,tenantCode);
    //保存新明细数据
    List<FiscalYearDetailEntity> entities = fiscalYearDetailDtos.stream()
        .map(dto -> {
          FiscalYearDetailEntity entity = this.nebulaToolkitService
              .copyObjectByWhiteList(dto, FiscalYearDetailEntity.class, HashSet.class, ArrayList.class);
          entity.setYear(year);
          entity.setTenantCode(tenantCode);
          return entity;
        }).collect(Collectors.toList());
    this.fiscalYearDetailRepository.saveBatch(entities);
  }
}