package com.biz.crm.mdm.business.fiscal.year.local.service;

import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearDetailDto;

import java.util.List;

/**
 * @Description 财年明细接口
 * @Author YangWei
 * @Date Created in 2022/2/28 下午4:41
 */
public interface FiscalYearDetailService {

  /**
   * 保存财年明细
   * @param fiscalYearDetailDtos 财年明细信息
   * @param year 年份
   * @param tenantCode 租户编号
   */
  void batchCreate(List<FiscalYearDetailDto> fiscalYearDetailDtos, String year, String tenantCode);

  /**
   * 更新财年明细
   * @param fiscalYearDetailDtos 财年明细信息
   * @param year 年份
   * @param tenantCode 租户编号
   */
  void batchUpdate(List<FiscalYearDetailDto> fiscalYearDetailDtos, String year, String tenantCode);
}