package com.biz.crm.mdm.business.fiscal.year.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.fiscal.year.local.entity.FiscalYearEntity;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearLinkageDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearPageDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.vo.FiscalYearVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 财年表服务接口
 *
 * @author ning.zhang
 * @date 2021-11-16 14:08:29
 */
public interface FiscalYearService {

  /**
   * 创建财年
   *
   * @param dto 请求参数dto
   * @return 财年实体
   */
  FiscalYearEntity create(FiscalYearDto dto);

  /**
   * 更新财年
   *
   * @param dto 请求参数dto
   * @return 财年实体
   */
  FiscalYearEntity update(FiscalYearDto dto);

  /**
   * 批量删除财年
   *
   * @param ids 财年id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量启用财年
   *
   * @param ids 财年id集合
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用财年
   *
   * @param ids 财年id集合
   */
  void disableBatch(List<String> ids);

  /**
   * 财年分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<FiscalYearEntity> 财年分页信息
   */
  Page<FiscalYearEntity> findByConditions(Pageable pageable, FiscalYearPageDto dto);

  /**
   * 通过ID获取财年信息
   *
   * @param id 财年ID
   * @return 财年信息
   */
  FiscalYearEntity findById(String id);

}
