/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.fiscal.year.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.fiscal.year.local.entity.FiscalYearEntity;
import com.biz.crm.mdm.business.fiscal.year.local.repository.FiscalYearDetailRepository;
import com.biz.crm.mdm.business.fiscal.year.local.repository.FiscalYearRepository;
import com.biz.crm.mdm.business.fiscal.year.local.service.FiscalYearDetailService;
import com.biz.crm.mdm.business.fiscal.year.local.service.FiscalYearService;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearDetailDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearPageDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.enums.FiscalHalfYearEnum;
import com.biz.crm.mdm.business.fiscal.year.sdk.enums.FiscalYearMonthEnum;
import com.biz.crm.mdm.business.fiscal.year.sdk.enums.FiscalYearQuarterEnum;
import com.biz.crm.mdm.business.fiscal.year.sdk.event.FiscalYearEventListener;
import com.biz.crm.mdm.business.fiscal.year.sdk.vo.FiscalYearEventVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="fiscalYearService")
public class FiscalYearServiceImpl
implements FiscalYearService {
    private static final Logger log = LoggerFactory.getLogger(FiscalYearServiceImpl.class);
    @Autowired(required=false)
    private FiscalYearRepository fiscalYearRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<FiscalYearEventListener> listeners;
    @Autowired(required=false)
    private FiscalYearDetailService fiscalYearDetailService;
    @Autowired(required=false)
    private FiscalYearDetailRepository fiscalYearDetailRepository;

    @Override
    @Transactional
    public FiscalYearEntity create(FiscalYearDto dto) {
        this.createValidation(dto);
        FiscalYearEntity entity = (FiscalYearEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, FiscalYearEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setTenantCode(TenantUtils.getTenantCode());
        this.fiscalYearRepository.save((Object)entity);
        this.fiscalYearDetailService.batchCreate(dto.getFiscalYearDetailDtos(), dto.getYear(), dto.getTenantCode());
        if (!CollectionUtils.isEmpty(this.listeners)) {
            FiscalYearEventVo vo = (FiscalYearEventVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, FiscalYearEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onCreate(vo));
        }
        return entity;
    }

    @Override
    @Transactional
    public FiscalYearEntity update(FiscalYearDto dto) {
        this.updateValidation(dto);
        FiscalYearEntity entity = this.fiscalYearRepository.findByIdAndTenantCode(dto.getId(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)entity), (String)"\u8d22\u5e74\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        FiscalYearEntity updateEntity = (FiscalYearEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, FiscalYearEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.fiscalYearRepository.updateById((Object)updateEntity);
        this.fiscalYearDetailService.batchUpdate(dto.getFiscalYearDetailDtos(), dto.getYear(), dto.getTenantCode());
        if (!CollectionUtils.isEmpty(this.listeners)) {
            FiscalYearEventVo oldVo = (FiscalYearEventVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, FiscalYearEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            FiscalYearEventVo newVo = (FiscalYearEventVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, FiscalYearEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onUpdate(oldVo, newVo));
        }
        return updateEntity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<FiscalYearEntity> entities = this.fiscalYearRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((!CollectionUtils.isEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.fiscalYearRepository.updateDelFlagByIds(ids);
        List<String> yearList = entities.stream().map(FiscalYearEntity::getYear).collect(Collectors.toList());
        this.fiscalYearDetailRepository.deleteByYear(yearList, TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, FiscalYearEntity.class, FiscalYearEventVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(listener -> listener.onDelete(voList));
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<FiscalYearEntity> entities = this.fiscalYearRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((!CollectionUtils.isEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u542f\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.fiscalYearRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, FiscalYearEntity.class, FiscalYearEventVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(listener -> listener.onEnable(voList));
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<FiscalYearEntity> entities = this.fiscalYearRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((!CollectionUtils.isEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.fiscalYearRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, FiscalYearEntity.class, FiscalYearEventVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(listener -> listener.onDisable(voList));
        }
    }

    @Override
    public Page<FiscalYearEntity> findByConditions(Pageable pageable, FiscalYearPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (FiscalYearPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new FiscalYearPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.fiscalYearRepository.findByConditions(pageable, dto);
    }

    @Override
    public FiscalYearEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.fiscalYearRepository.findById(id, TenantUtils.getTenantCode());
    }

    private void createValidation(FiscalYearDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setId(null);
        this.validityCheck(dto);
        this.detailCheck(dto);
    }

    private void updateValidation(FiscalYearDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validityCheck(dto);
        this.detailCheck(dto);
    }

    private void validityCheck(FiscalYearDto dto) {
        String year = dto.getYear();
        Date beginTime = dto.getBeginTime();
        Date endTime = dto.getEndTime();
        Validate.notBlank((CharSequence)dto.getTenantCode(), (String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)year, (String)"\u9884\u7b97\u8d22\u5e74\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)beginTime, (String)"\u8d22\u5e74\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)endTime, (String)"\u8d22\u5e74\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<FiscalYearEntity> existList = this.fiscalYearRepository.findByFiscalYearDto(dto);
        Map existMap = existList.stream().filter(o -> !o.getId().equals(dto.getId())).collect(Collectors.toMap(FiscalYearEntity::getYear, Function.identity()));
        FiscalYearEntity fiscalYearEntity = (FiscalYearEntity)((Object)existMap.get(dto.getYear()));
        Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)fiscalYearEntity)), (String)"\u9884\u7b97\u8d22\u5e74\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199", (Object[])new Object[0]);
        existList.stream().filter(o -> !o.getId().equals(dto.getId())).forEach(o -> {
            Date existBeginTime = o.getBeginTime();
            Date existEndTime = o.getEndTime();
            boolean timeFlag = true;
            if (existBeginTime.compareTo(beginTime) <= 0 && existEndTime.compareTo(beginTime) >= 0 || existBeginTime.compareTo(endTime) <= 0 && existEndTime.compareTo(endTime) >= 0 || existBeginTime.compareTo(beginTime) <= 0 && existEndTime.compareTo(endTime) >= 0 || existBeginTime.compareTo(beginTime) >= 0 && existEndTime.compareTo(endTime) <= 0) {
                timeFlag = false;
            }
            Validate.isTrue((boolean)timeFlag, (String)("\u4e0e\u5386\u53f2\u8d22\u5e74[" + o.getYear() + "]\u5b58\u5728\u65f6\u95f4\u4ea4\u53c9"), (Object[])new Object[0]);
        });
    }

    private void detailCheck(FiscalYearDto dto) {
        Date yearBeginTime = dto.getBeginTime();
        Date yearEndTime = dto.getEndTime();
        List fiscalYearDetailDtos = dto.getFiscalYearDetailDtos();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)fiscalYearDetailDtos) ? 1 : 0) != 0, (String)"\u8d22\u5e74\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((fiscalYearDetailDtos.size() == 12 ? 1 : 0) != 0, (String)"\u8d22\u5e74\u660e\u7ec6\u6708\u4efd\u6570\u91cf\u9519\u8bef", (Object[])new Object[0]);
        HashMap quarterMap = Maps.newHashMap();
        this.quarterMonthCheck(fiscalYearDetailDtos, quarterMap);
        Map oneQuarterMap = (Map)quarterMap.get(FiscalYearQuarterEnum.Q1TH.getDictCode());
        FiscalYearDetailDto janMonth = (FiscalYearDetailDto)oneQuarterMap.get(FiscalYearMonthEnum.JAN.getDictCode());
        Date janBeginTime = janMonth.getBeginTime();
        Map fourQuarterMap = (Map)quarterMap.get(FiscalYearQuarterEnum.Q4TH.getDictCode());
        FiscalYearDetailDto decMonth = (FiscalYearDetailDto)fourQuarterMap.get(FiscalYearMonthEnum.DEC.getDictCode());
        Date decEndTime = decMonth.getEndTime();
        Validate.isTrue((yearBeginTime.compareTo(janBeginTime) == 0 ? 1 : 0) != 0, (String)"\u8d22\u5e74\u4e00\u6708\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u7b49\u4e8e\u8d22\u5e74\u5f00\u59cb\u65e5\u671f", (Object[])new Object[0]);
        Validate.isTrue((yearEndTime.compareTo(decEndTime) == 0 ? 1 : 0) != 0, (String)"\u8d22\u5e74\u5341\u4e8c\u6708\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u7b49\u4e8e\u8d22\u5e74\u7ed3\u675f\u65e5\u671f", (Object[])new Object[0]);
        Map monthMap = fiscalYearDetailDtos.stream().collect(Collectors.toMap(FiscalYearDetailDto::getMonth, Function.identity()));
        fiscalYearDetailDtos.stream().sorted(Comparator.comparing(o -> Integer.valueOf(o.getMonth()))).forEach(o -> {
            Integer month = Integer.valueOf(o.getMonth());
            if (Integer.valueOf(o.getMonth()) >= 7) {
                o.setHalfYear(FiscalHalfYearEnum.DOWN_YEAR.getCode());
            } else {
                o.setHalfYear(FiscalHalfYearEnum.UP_YEAR.getCode());
            }
            Validate.isTrue((o.getBeginTime().compareTo(o.getEndTime()) < 0 ? 1 : 0) != 0, (String)"\u6708\u4efd\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
            int lastMonth = month - 1;
            FiscalYearDetailDto lastMonthDto = (FiscalYearDetailDto)monthMap.get(String.valueOf(lastMonth));
            if (ObjectUtils.isNotEmpty((Object)lastMonthDto)) {
                Date lastMonthEndTime = lastMonthDto.getEndTime();
                Validate.isTrue((lastMonthEndTime.compareTo(o.getBeginTime()) < 0 ? 1 : 0) != 0, (String)(month + "\u6708\u4efd\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u4e0a\u4e00\u4e2a\u6708\u7ed3\u675f\u65e5\u671f"), (Object[])new Object[0]);
                Calendar cl = Calendar.getInstance();
                cl.setTime(lastMonthEndTime);
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, 0);
                cl.add(5, 1);
                Date beginTime = cl.getTime();
                Validate.isTrue((beginTime.compareTo(o.getBeginTime()) == 0 ? 1 : 0) != 0, (String)(month + "\u6708\u4efd\u5f00\u59cb\u65e5\u671f\u4e0e\u4e0a\u4e00\u4e2a\u6708\u7ed3\u675f\u65e5\u671f\u5b58\u5728\u9057\u6f0f"), (Object[])new Object[0]);
            }
        });
    }

    private void quarterMonthCheck(List<FiscalYearDetailDto> fiscalYearDetailDtos, Map<String, Map<String, FiscalYearDetailDto>> quarterMap) {
        fiscalYearDetailDtos.forEach(o -> {
            String quarter = o.getQuarter();
            String month = o.getMonth();
            Validate.notBlank((CharSequence)o.getMonth(), (String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getQuarter(), (String)"\u5b63\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)o.getBeginTime(), (String)"\u8d22\u5e74\u6708\u4efd\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)o.getEndTime(), (String)"\u8d22\u5e74\u6708\u4efd\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            FiscalYearQuarterEnum quarterEnum = FiscalYearQuarterEnum.getByDictCode((String)quarter);
            Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)quarterEnum), (String)("\u5b63\u5ea6[" + quarter + "]\u6570\u503c\u9519\u8bef"), (Object[])new Object[0]);
            Map monthMap = (Map)quarterMap.get(quarter);
            if (CollectionUtils.isEmpty((Map)monthMap)) {
                monthMap = Maps.newHashMap();
            }
            FiscalYearMonthEnum monthEnum = FiscalYearMonthEnum.getByDictCode((String)month);
            Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)monthEnum), (String)("\u6708\u5ea6[" + month + "]\u6570\u503c\u9519\u8bef"), (Object[])new Object[0]);
            block0 : switch (quarterEnum) {
                case Q1TH: {
                    switch (monthEnum) {
                        case JAN: 
                        case FEB: 
                        case MAR: {
                            if (ObjectUtils.isNotEmpty(monthMap.get(month))) {
                                throw new IllegalArgumentException(quarter + "\u5b63\u5ea6\u5b58\u5728\u591a\u4e2a" + month + "\u6708\u4efd");
                            }
                            monthMap.put(month, o);
                            quarterMap.put(quarter, monthMap);
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException(quarter + "\u5b63\u5ea6" + month + "\u6708\u4efd\u9519\u8bef");
                }
                case Q2ND: {
                    switch (monthEnum) {
                        case APR: 
                        case MAY: 
                        case JUN: {
                            if (ObjectUtils.isNotEmpty(monthMap.get(month))) {
                                throw new IllegalArgumentException(quarter + "\u5b63\u5ea6\u5b58\u5728\u591a\u4e2a" + month + "\u6708\u4efd");
                            }
                            monthMap.put(month, o);
                            quarterMap.put(quarter, monthMap);
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException(quarter + "\u5b63\u5ea6" + month + "\u6708\u4efd\u9519\u8bef");
                }
                case Q3RD: {
                    switch (monthEnum) {
                        case JUL: 
                        case AUG: 
                        case SEPT: {
                            if (ObjectUtils.isNotEmpty(monthMap.get(month))) {
                                throw new IllegalArgumentException(quarter + "\u5b63\u5ea6\u5b58\u5728\u591a\u4e2a" + month + "\u6708\u4efd");
                            }
                            monthMap.put(month, o);
                            quarterMap.put(quarter, monthMap);
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException(quarter + "\u5b63\u5ea6" + month + "\u6708\u4efd\u9519\u8bef");
                }
                case Q4TH: {
                    switch (monthEnum) {
                        case OCT: 
                        case NOV: 
                        case DEC: {
                            if (ObjectUtils.isNotEmpty(monthMap.get(month))) {
                                throw new IllegalArgumentException(quarter + "\u5b63\u5ea6\u5b58\u5728\u591a\u4e2a" + month + "\u6708\u4efd");
                            }
                            monthMap.put(month, o);
                            quarterMap.put(quarter, monthMap);
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException(quarter + "\u5b63\u5ea6" + month + "\u6708\u4efd\u9519\u8bef");
                }
            }
        });
    }
}

