package com.biz.crm.mdm.business.fiscal.year.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Project crm
 * @PackageName com.biz.crm.mdm.business.fiscal.year.sdk.dto
 * @ClassName FiscalYearDetailDto
 * @Author YangWei
 * @Date 2022/2/28 下午4:32
 * @Description 财年明细Dto
 */
@Data
@ApiModel(value = "FiscalYearDetailDto", description = "财年明细Dto")
public class FiscalYearDetailDto extends TenantDto {
  /**
   * 预算年(字典编码)
   */
  @ApiModelProperty("预算年(字典编码)")
  private String year;
  /**
   * 预算季度(字典编码)
   */
  @ApiModelProperty("预算季度(字典编码)")
  private String quarter;
  /**
   * 预算月度(字典编码)
   */
  @ApiModelProperty("预算月度(字典编码)")
  private String month;
  /**
   * 预算半年度(字典编码)
   */
  @ApiModelProperty("预算半年度(字典编码)")
  private String halfYear;
  /**
   * 开始时间
   */
  @ApiModelProperty("开始时间(yyyy-MM-dd HH:mm:ss),如果只选日期后面的时分秒传(00:00:00)")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date beginTime;
  /**
   * 结束时间
   */
  @ApiModelProperty("结束时间(yyyy-MM-dd HH:mm:ss),如果只选日期后面的时分秒传(23:59:59)")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;
}