package com.biz.crm.mdm.business.fiscal.year.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 财年联动查询Dto
 *
 * @author ning.zhang
 * @date 2022/1/17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FiscalYearLinkageDto", description = "财年联动查询Dto")
public class FiscalYearLinkageDto extends TenantDto {

  /**
   * 预算年(字典编码)
   */
  @ApiModelProperty("预算年(字典编码)")
  private String year;

  /**
   * 财年类型(1:年度,2:季度,3:月度)
   */
  @ApiModelProperty("财年类型(1:年度,2:季度,3:月度)")
  private String fiscalYearType;

  /**
   * 启用状态
   */
  @ApiModelProperty("启用状态")
  private String enableStatus;

}
