package com.biz.crm.mdm.business.fiscal.year.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Project crm
 * @PackageName com.biz.crm.mdm.business.fiscal.year.sdk.dto
 * @ClassName FiscalYearReconciliationDto
 * @Author YangWei
 * @Date 2022/4/15 下午2:36
 * @Description 对账规则财年查询dto
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FiscalYearReconciliationDto", description = "对账规则财年查询dto")
public class FiscalYearReconciliationDto extends TenantDto {
  /**
   * 财年类型(1:年度,2:季度,3:月度)
   */
  @ApiModelProperty("财年类型(1:年度,2:季度,3:月度)")
  private String fiscalYearType;

  /**
   * 开始时间
   */
  @ApiModelProperty("开始时间(yyyy-MM-dd HH:mm:ss),如果只选日期后面的时分秒传(00:00:00)")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date beginTime;
  /**
   * 结束时间
   */
  @ApiModelProperty("结束时间(yyyy-MM-dd HH:mm:ss),如果只选日期后面的时分秒传(23:59:59)")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;
}