package com.biz.crm.mdm.business.fiscal.year.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 财年事件Vo
 *
 * @author ning.zhang
 * @date 2021/11/16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
public class FiscalYearEventVo extends TenantVo {

  private static final long serialVersionUID = -5969822035189914061L;

  /**
   * 预算年(字典编码)
   */
  private String year;
  /**
   * 预算季度(字典编码)
   */
  private String quarter;
  /**
   * 预算月度(字典编码)
   */
  private String month;
  /**
   * 预算半年度(字典编码)
   */
  private String halfYear;
  /**
   * 开始时间
   */
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date beginTime;
  /**
   * 结束时间
   */
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

}
