package com.biz.crm.mdm.business.fiscal.year.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 财年类型枚举
 *
 * @author ning.zhang
 * @date 2022/1/18
 */
@Getter
@AllArgsConstructor
public enum FiscalYearTypeEnum {

  /**
   * 年度
   */
  YEARLY("fiscalYearTypeEnum", "1", "年度", "1"),

  /**
   * 季度
   */
  QUARTER("fiscalYearTypeEnum", "2", "季度", "2"),

  /**
   * 月度
   */
  MONTHLY("fiscalYearTypeEnum", "3", "月度", "3"),;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  /**
   * 通过key获取 枚举值
   *
   * @param dictCode 字典值
   * @return 枚举值
   */
  public static FiscalYearTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(FiscalYearTypeEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode)).findFirst().orElse(null);
  }
}
