package com.biz.crm.mdm.business.fiscal.year.sdk.service;

import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearLinkageDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearPageDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearReconciliationDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.vo.FiscalYearVo;

import java.util.Date;
import java.util.List;

/**
 * @Description 财年设置VO服务接口类
 * @Author YangWei
 * @Date Created in 2022/3/2 下午5:35
 */
public interface FiscalYearVoService {

  /**
   * 财年联动查询
   *
   * @param dto 请求dto
   * @return 财年信息
   */
  List<FiscalYearVo> findByFiscalYearLinkageDto(FiscalYearLinkageDto dto);

  /**
   * 根据时间和财年类型查询
   * @param dto
   * @return
   */
  List<FiscalYearVo> findByFiscalYearReconciliationDto(FiscalYearReconciliationDto dto);

  /**
   * 根据时间查询财年信息
   * @param beginTime
   * @param endTime
   * @return
   */
  List<FiscalYearVo> findByBeginTimeAndEndTime(Date beginTime, Date endTime);
}