package com.biz.crm.mdm.business.fiscal.year.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.business.common.sdk.vo.TenantVo;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Project crm
 * @PackageName com.biz.crm.mdm.business.fiscal.year.sdk.vo
 * @ClassName FiscalYearLinkageVo
 * @Author YangWei
 * @Date 2022/3/2 上午11:30
 * @Description 销量目标财年联动查询Vo
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FiscalYearVo", description = "财年设置VO类")
public class FiscalYearVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 5981455998948668957L;

  /**
   * 预算年(字典编码)
   */
  @ApiModelProperty("预算年(字典编码)")
  private String year;

  /**
   * 预算季度(字典编码)
   */
  @ApiModelProperty("季度(字典编码)")
  private String quarter;

  /**
   * 预算月度(字典编码)
   */
  @ApiModelProperty("月度(字典编码)")
  private String month;

  /**
   * 预算半年度(字典编码)
   */
  @ApiModelProperty("半年度(字典编码)")
  private String halfYear;

  /**
   * 开始时间
   */
  @ApiModelProperty("开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date beginTime;

  /**
   * 结束时间
   */
  @ApiModelProperty("开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;
}