package com.biz.crm.mdm.business.inquiry.feign.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.inquiry.feign.feign.internal.InquiryVoServiceFeign;
import com.biz.crm.mdm.business.inquiry.sdk.service.InquiryVoService;
import com.biz.crm.mdm.business.inquiry.sdk.vo.InquiryVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 询价sdk接口实现
 *
 * @author sunx
 * @date 2022/1/6
 */
@Service
public class InquiryVoServiceImpl implements InquiryVoService {

  @Autowired(required = false)
  private InquiryVoServiceFeign inquiryVoServiceFeign;

  @Override
  public Map<String, InquiryVo> handleSearchPrice(JSONObject object) {
    return this.inquiryVoServiceFeign.handleSearchPrice(object).checkFeignResult();
  }

  @Override
  public Map<String, InquiryVo> findPrice(JSONObject object) {
    return this.inquiryVoServiceFeign.findPrice(object).checkFeignResult();
  }

  @Override
  public Map<String, InquiryVo> findBusinessPrice(JSONObject object) {
    return this.inquiryVoServiceFeign.findBusinessPrice(object).checkFeignResult();
  }
}
