package com.biz.crm.mdm.business.inquiry.feign.feign;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.inquiry.feign.feign.internal.InquiryVoServiceFeign;
import com.biz.crm.mdm.business.inquiry.sdk.vo.InquiryVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 价格管理feign实现
 *
 * @author sunx
 * @date 2022/1/6
 */
@Component
public class InquiryVoServiceFeignImpl implements FallbackFactory<InquiryVoServiceFeign> {

  @Override
  public InquiryVoServiceFeign create(Throwable throwable) {

    return new InquiryVoServiceFeign() {
      @Override
      public Result<Map<String, InquiryVo>> handleSearchPrice(JSONObject object) {
        throw new UnsupportedOperationException("查询价格熔断");
      }

      @Override
      public Result<Map<String, InquiryVo>> findPrice(JSONObject object) {
        throw new UnsupportedOperationException("询价熔断");
      }

      @Override
      public Result<Map<String, InquiryVo>> findBusinessPrice(JSONObject object) {
        throw new UnsupportedOperationException("询价熔断");
      }
    };
  }
}
