package com.biz.crm.mdm.business.inquiry.feign.feign.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.inquiry.sdk.vo.InquiryVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Map;

/**
 * @author songjingen
 * @date 2022/8/16
 */
public interface InquiryVoServiceFeign {


  /**
   * 查询价格
   *
   * @param object
   * @return
   */
  @ApiOperation(value = "查询价格")
  @PostMapping(value = {"/v1/inquiry/inquiry/handleSearchPrice"})
  Result<Map<String, InquiryVo>> handleSearchPrice(@RequestBody JSONObject object);

  /**
   * 询价
   *
   * @param object
   * @return
   */
  @ApiOperation(value = "询价")
  @PostMapping(value = {"/v1/inquiry/inquiry/findPrice"})
  Result<Map<String, InquiryVo>> findPrice(@RequestBody JSONObject object);

  /**
   * 根据业务编码及商品维度询价
   *
   * @param object
   * @return
   */
  @ApiOperation(value = "根据业务编码及商品维度询价")
  @PostMapping(value = {"/v1/inquiry/inquiry/findBusinessPrice"})
  Result<Map<String, InquiryVo>> findBusinessPrice(@RequestBody JSONObject object);
}
