/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.inquiry.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.inquiry.sdk.service.InquiryVoService;
import com.biz.crm.mdm.business.inquiry.sdk.vo.InquiryVo;
import com.biz.crm.mdm.business.price.sdk.dto.FindBusinessPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultInquiryVoServiceImpl
implements InquiryVoService {
    private static final Logger log = LoggerFactory.getLogger(DefaultInquiryVoServiceImpl.class);
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Map<String, InquiryVo> handleSearchPrice(JSONObject object) {
        if (object == null) {
            return new HashMap<String, InquiryVo>(0);
        }
        SearchPriceDto dto = (SearchPriceDto)JsonUtils.json2Obj((String)object.toJSONString(), SearchPriceDto.class);
        Map stringPriceModelVoMap = this.priceModelVoService.handleSearchPrice(dto);
        return this.convert(stringPriceModelVoMap);
    }

    public Map<String, InquiryVo> findPrice(JSONObject object) {
        if (object == null) {
            return new HashMap<String, InquiryVo>(0);
        }
        FindPriceDto dto = (FindPriceDto)JsonUtils.json2Obj((String)object.toJSONString(), FindPriceDto.class);
        Map stringPriceModelVoMap = this.priceModelVoService.findPrice(dto);
        return this.convert(stringPriceModelVoMap);
    }

    public Map<String, InquiryVo> findBusinessPrice(JSONObject object) {
        if (object == null) {
            return new HashMap<String, InquiryVo>(0);
        }
        FindBusinessPriceDto dto = (FindBusinessPriceDto)JsonUtils.json2Obj((String)object.toJSONString(), FindBusinessPriceDto.class);
        Map stringPriceModelVoMap = this.priceModelVoService.findBusinessPrice(dto);
        return this.convert(stringPriceModelVoMap);
    }

    private Map<String, InquiryVo> convert(Map<String, PriceModelVo> stringPriceModelVoMap) {
        if (stringPriceModelVoMap == null) {
            return Maps.newHashMap();
        }
        HashMap<String, InquiryVo> stringInquiryVoHashMap = new HashMap<String, InquiryVo>();
        for (Map.Entry<String, PriceModelVo> entry : stringPriceModelVoMap.entrySet()) {
            InquiryVo inquiryVo = (InquiryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entry.getValue(), InquiryVo.class, HashSet.class, ArrayList.class, new String[0]);
            stringInquiryVoHashMap.put(entry.getKey(), inquiryVo);
        }
        return stringInquiryVoHashMap;
    }
}

