package com.biz.crm.mdm.business.inquiry.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.inquiry.sdk.service.InquiryVoService;
import com.biz.crm.mdm.business.inquiry.sdk.vo.InquiryVo;
import com.biz.crm.mdm.business.price.sdk.dto.FindBusinessPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/**
 * 价格查询sdk接口实现（默认实现）优先级最低
 *
 * @author sunx
 * @date 2022/1/4
 */

@Slf4j
@Service
public class DefaultInquiryVoServiceImpl implements InquiryVoService {

  @Autowired(required = false)
  private PriceModelVoService priceModelVoService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Map<String, InquiryVo> handleSearchPrice(JSONObject object) {
    if (object == null) {
      return new HashMap<>(0);
    }
    SearchPriceDto dto = JsonUtils.json2Obj(object.toJSONString(), SearchPriceDto.class);
    Map<String, PriceModelVo> stringPriceModelVoMap = this.priceModelVoService.handleSearchPrice(dto);
    return this.convert(stringPriceModelVoMap);
  }

  @Override
  public Map<String, InquiryVo> findPrice(JSONObject object) {
    if (object == null) {
      return new HashMap<>(0);
    }
    FindPriceDto dto = JsonUtils.json2Obj(object.toJSONString(), FindPriceDto.class);
    Map<String, PriceModelVo> stringPriceModelVoMap = this.priceModelVoService.findPrice(dto);
    return this.convert(stringPriceModelVoMap);
  }

  @Override
  public Map<String, InquiryVo> findBusinessPrice(JSONObject object) {
    if (object == null) {
      return new HashMap<>(0);
    }
    FindBusinessPriceDto dto = JsonUtils.json2Obj(object.toJSONString(), FindBusinessPriceDto.class);
    Map<String, PriceModelVo> stringPriceModelVoMap = this.priceModelVoService.findBusinessPrice(dto);
    return this.convert(stringPriceModelVoMap);
  }

  /**
   * 数据转换
   *
   * @param stringPriceModelVoMap
   */
  private Map<String, InquiryVo> convert(Map<String, PriceModelVo> stringPriceModelVoMap) {
    if (stringPriceModelVoMap == null) {
      return Maps.newHashMap();
    }
    Map<String, InquiryVo> stringInquiryVoHashMap = new HashMap<>();
    for (Map.Entry<String, PriceModelVo> entry : stringPriceModelVoMap.entrySet()) {
      InquiryVo inquiryVo = this.nebulaToolkitService.copyObjectByWhiteList(entry.getValue(), InquiryVo.class, HashSet.class, ArrayList.class);
      stringInquiryVoHashMap.put(entry.getKey(), inquiryVo);
    }
    return stringInquiryVoHashMap;
  }
}
