package com.biz.crm.mdm.business.material.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.material.feign.feign.MaterialVoServiceFeign;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import feign.hystrix.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 物料feign熔断实现
 * @author sunx
 * @date 2021/11/16
 */
@Component
public class MaterialVoServiceFeignImpl implements FallbackFactory<MaterialVoServiceFeign> {

  @Override
  public MaterialVoServiceFeign create(Throwable throwable) {
    return new MaterialVoServiceFeign() {
      @Override
      public Result<MaterialVo> findDetailByMaterialCode(String materialCode) {
        throw new UnsupportedOperationException("根据物料编码查询详情熔断");
      }

      @Override
      public Result<List<MaterialVo>> findDetailByMaterialCodes(Set<String> materialCodes) {
        throw new UnsupportedOperationException("根据物料编码集合查询详情熔断");
      }
    };
  }
}
