package com.biz.crm.mdm.business.material.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.material.feign.feign.MaterialVoFeign;
import com.biz.crm.mdm.business.material.feign.feign.MaterialVoServiceFeign;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialDto;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialPageDto;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialSearchDto;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * 物料sdk实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Service
public class MaterialVoFeignServiceImpl implements MaterialVoService {

  @Autowired(required = false)
  private MaterialVoServiceFeign materialVoServiceFeign;

  @Autowired(required = false)
  private MaterialVoFeign materialVoFeign;

  @Override
  public List<MaterialVo> findAll() {
    return materialVoServiceFeign.findAll().checkFeignResult();
  }

  @Override
  public Page<MaterialVo> findByConditions(Pageable pageable, MaterialDto materialDto) {
    throw new UnsupportedOperationException();
  }


  @Override
  public MaterialVo findDetailById(String id) {
    throw new UnsupportedOperationException();
  }

  @Override
  public MaterialVo findDetailByMaterialCode(String materialCode) {
    return materialVoServiceFeign.findDetailByMaterialCode(materialCode).checkFeignResult();
  }

  @Override
  public List<MaterialVo> findDetailByMaterialCodes(Set<String> materialCodes) {
    if (CollectionUtils.isEmpty(materialCodes)) {
      return null;
    }
    return materialVoServiceFeign.findDetailByMaterialCodes(materialCodes).checkFeignResult();
  }

  @Override
  public Page<MaterialVo> findByMaterialPageDto(Pageable pageable, MaterialPageDto dto) {
    return materialVoFeign.findByMaterialPageDto(pageable.getPageNumber(),pageable.getPageSize(),dto).checkFeignResult();
  }

  @Override
  public Set<String> findCodeByProductLevelCodes(Set<String> productLevelCodeSet) {
    return materialVoFeign.findCodeByProductLevelCodes(productLevelCodeSet).checkFeignResult();
  }

  @Override
  public List<MaterialVo> findMaterialByIds(MaterialSearchDto materialSearchDto) {
    return materialVoFeign.findMaterialByIds(materialSearchDto).checkFeignResult();
  }

  @Override
  public void save(MaterialDto materialDto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void update(MaterialDto materialDto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void deleteBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void enableBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void disableBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }
}
