package com.biz.crm.mdm.business.material.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * 物料实体类
 *
 * @author pengxi
 * @date 2021-09-27 14:44:10
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "mdm_material")
@TableName(value = "mdm_material")
@org.hibernate.annotations.Table(appliesTo = "mdm_material", comment = "物料表")
public class MaterialEntity extends TenantFlagOpEntity {
  private static final long serialVersionUID = -9118460549634973539L;

  /**
   * 产品层级编码
   */
  @TableField(value = "product_level_code")
  @Column(name = "product_level_code", length = 64, columnDefinition = "varchar(64) COMMENT '产品层级编码'")
  private String productLevelCode;

  /**
   * 物料编码
   */
  @TableField(value = "material_code")
  @Column(name = "material_code", length = 64, columnDefinition = "varchar(64) COMMENT '物料编码'")
  private String materialCode;

  /**
   * 产品名称
   */
  @TableField(value = "material_name")
  @Column(name = "material_name", length = 64, columnDefinition = "varchar(64) COMMENT '产品名称'")
  private String materialName;

  /**
   * ai编码
   */
  @TableField(value = "ai_code")
  @Column(name = "ai_code", length = 64, columnDefinition = "varchar(64) COMMENT 'ai编码'")
  private String aiCode;

  /**
   * 条形码
   */
  @TableField(value = "bar_code")
  @Column(name = "bar_code", length = 64, columnDefinition = "varchar(64) COMMENT '条形码'")
  private String barCode;

  /**
   * 物料类型
   */
  @TableField(value = "material_type")
  @Column(name = "material_type", length = 64, columnDefinition = "varchar(64) COMMENT '物料类型'")
  private String materialType;

  /**
   * 销售公司
   */
  @TableField(value = "sale_company")
  @Column(name = "sale_company", length = 64, columnDefinition = "varchar(64) COMMENT '销售公司'")
  private String saleCompany;

  /**
   * 规格
   */
  @TableField(value = "specification")
  @Column(name = "specification", length = 64, columnDefinition = "varchar(64) COMMENT '规格'")
  private String specification;

  /**
   * 成本价格
   */
  @TableField(value = "cost_price")
  @Column(name = "cost_price", length = 64, columnDefinition = "varchar(64) COMMENT '成本价格'")
  private String costPrice;

  /**
   * 毛重
   */
  @TableField(value = "gross_weight")
  @Column(name = "gross_weight", length = 64, columnDefinition = "varchar(64) COMMENT '毛重'")
  private String grossWeight;

  /**
   * 净重
   */
  @TableField(value = "net_weight")
  @Column(name = "net_weight", length = 64, columnDefinition = "varchar(64) COMMENT '净重'")
  private String netWeight;

  /**
   * 容量
   */
  @TableField(value = "capacity")
  @Column(name = "capacity", length = 64, columnDefinition = "varchar(64) COMMENT '容量'")
  private String capacity;

  /**
   * 标准单位
   */
  @TableField(value = "standard_unit")
  @Column(name = "standard_unit", length = 64, columnDefinition = "varchar(64) COMMENT '标准单位'")
  private String standardUnit;

  /**
   * 单位名称
   */
  @TableField(value = "unit_conversion")
  @Column(name = "unit_conversion", length = 64, columnDefinition = "varchar(64) COMMENT '单位名称'")
  private String unitConversion;

  /**
   * 盒码单位转换系数
   */
  @TableField(value = "box_unit_conversion")
  @Column(name = "box_unit_conversion", length = 64, columnDefinition = "decimal(10,2) COMMENT '盒码单位转换系数'")
  private BigDecimal boxUnitConversion;

  /**
   * 箱码单位转换系数
   */
  @TableField(value = "case_unit_conversion")
  @Column(name = "case_unit_conversion", length = 64, columnDefinition = "decimal(10,2) COMMENT '箱码单位转换系数'")
  private BigDecimal caseUnitConversion;

  /**
   * 物料单位类型编码
   */
  @TableField(value = "unit_type_code")
  @Column(name = "unit_type_code", length = 64, columnDefinition = "varchar(64) COMMENT '物料单位类型编码'")
  private String unitTypeCode;

  /**
   * 物料图片信息
   */
  @ApiModelProperty("物料图片信息")
  @Transient
  @TableField(exist = false)
  private List<MaterialMediaEntity> picList;
}
