package com.biz.crm.mdm.business.material.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.material.local.entity.MaterialEntity;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialDto;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialPageDto;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import java.util.Set;
import org.apache.ibatis.annotations.Param;

/**
 * 物料数据库接口层
 *
 * @author pengxi
 * @date 2021-09-27 14:44:10
 */
public interface MaterialMapper extends BaseMapper<MaterialEntity> {

  /**
   * 分页查询
   *
   * @param page    分页参数
   * @param materialDto 业务参数
   * @return Page
   */
  Page<MaterialVo> findByConditions(Page<MaterialEntity> page, @Param("dto") MaterialDto materialDto);

  /**
   * 通过物料id查询物料信息
   * @param id 物料id
   * @return 物料信息
   */
  MaterialEntity findById(@Param("id") String id);

  /**
   * 分页查询
   *
   * @param page    分页参数
   * @param dto 业务参数
   * @return Page
   */
  Page<MaterialEntity> findByMaterialPageDto(Page<MaterialEntity> page, @Param("dto") MaterialPageDto dto);

  /**
   * 根据层级编码查询可用的物料编码集合
   * @param productLevelCodeSet
   * @param enableStatus
   * @param delFlag
   * @param tenantCode
   */
  Set<String> findCodeByProductLevelCodes(@Param("list") Set<String> productLevelCodeSet,
      @Param("enableStatus") String enableStatus,
      @Param("delFlag") String delFlag,
      @Param("tenantCode") String tenantCode);
}
