package com.biz.crm.mdm.business.material.local.service.internal;

import com.biz.crm.mdm.business.material.local.entity.MaterialMediaEntity;
import com.biz.crm.mdm.business.material.local.repository.MaterialMediaRepository;
import com.biz.crm.mdm.business.material.local.service.MaterialMediaService;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialMediaDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 物料图片表服务实现类
 *
 * @author ning.zhang
 * @date 2021-12-13 10:26:04
 */
@Slf4j
@Service("materialMediaService")
public class MaterialMediaServiceImpl implements MaterialMediaService {

  @Autowired(required = false)
  private MaterialMediaRepository materialMediaRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public void update(List<MaterialMediaDto> dtoList, String materialId) {
    Validate.notBlank(materialId, "物料ID不能为空");
    this.materialMediaRepository.deleteByMaterialId(materialId);
    //TODO 删除文件系统文件数据
    if (CollectionUtils.isEmpty(dtoList)) {
      return;
    }
    String tenantCode = TenantUtils.getTenantCode();
    //过滤无效的数据
    List<MaterialMediaEntity> entities = dtoList.stream()
        .filter(Objects::nonNull)
        .map(dto -> {
          MaterialMediaEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(dto, MaterialMediaEntity.class, HashSet.class, ArrayList.class);
          entity.setMaterialId(materialId);
          entity.setTenantCode(tenantCode);
          return entity;
        }).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(entities)) {
      return;
    }
    this.materialMediaRepository.saveBatch(entities);
  }
}
