/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.material.local.service.internal;

import com.biz.crm.mdm.business.material.local.entity.MaterialMediaEntity;
import com.biz.crm.mdm.business.material.local.repository.MaterialMediaRepository;
import com.biz.crm.mdm.business.material.local.service.MaterialMediaService;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialMediaDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="materialMediaService")
public class MaterialMediaServiceImpl
implements MaterialMediaService {
    private static final Logger log = LoggerFactory.getLogger(MaterialMediaServiceImpl.class);
    @Autowired(required=false)
    private MaterialMediaRepository materialMediaRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public void update(List<MaterialMediaDto> dtoList, String materialId) {
        Validate.notBlank((CharSequence)materialId, (String)"\u7269\u6599ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialMediaRepository.deleteByMaterialId(materialId);
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        List entities = dtoList.stream().filter(Objects::nonNull).map(dto -> {
            MaterialMediaEntity entity = (MaterialMediaEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, MaterialMediaEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setMaterialId(materialId);
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.materialMediaRepository.saveBatch(entities);
    }
}

