/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.material.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.material.local.entity.MaterialEntity;
import com.biz.crm.mdm.business.material.local.entity.MaterialMediaEntity;
import com.biz.crm.mdm.business.material.local.repository.MaterialMediaRepository;
import com.biz.crm.mdm.business.material.local.repository.MaterialRepository;
import com.biz.crm.mdm.business.material.local.service.MaterialMediaService;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialDto;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialPageDto;
import com.biz.crm.mdm.business.material.sdk.event.MaterialEventListener;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialEventVo;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialMediaVo;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.biz.crm.mdm.business.material.unit.dto.MaterialUnitTypeDto;
import com.biz.crm.mdm.business.material.unit.service.MaterialUnitTypeVoService;
import com.biz.crm.mdm.business.material.unit.vo.MaterialUnitTypeVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MaterialVoServiceImpl
implements MaterialVoService {
    @Autowired(required=false)
    private MaterialRepository materialRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private MaterialUnitTypeVoService materialUnitTypeVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MaterialMediaService materialMediaService;
    @Autowired(required=false)
    private MaterialMediaRepository materialMediaRepository;
    @Autowired(required=false)
    private List<MaterialEventListener> materialEventListeners;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    public Page<MaterialVo> findByConditions(Pageable pageable, MaterialDto dto) {
        Page<MaterialVo> materialVoPage;
        if (StringUtils.isNotBlank((CharSequence)(dto = Optional.ofNullable(dto).orElse(new MaterialDto())).getProductLevelCode())) {
            List productLevelCodes = this.productLevelVoSdkService.findCurAndChildrenCodesByCodes((Set)Sets.newHashSet((Object[])new String[]{dto.getProductLevelCode()}));
            dto.setProductLevelCodes(productLevelCodes);
        }
        if ((materialVoPage = this.materialRepository.findByConditions(pageable, dto)).getCurrent() == 0L) {
            return materialVoPage;
        }
        List productLevelCodes = materialVoPage.getRecords().stream().map(MaterialVo::getProductLevelCode).distinct().collect(Collectors.toList());
        List productLevelVos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(productLevelCodes)) {
            productLevelVos = this.productLevelVoSdkService.findListByCodes(productLevelCodes);
        }
        List<String> materialIds = materialVoPage.getRecords().stream().map(UuidVo::getId).collect(Collectors.toList());
        List<Object> mediaEntities = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(materialIds)) {
            mediaEntities = this.materialMediaRepository.findByMaterialIds(materialIds);
        }
        Map<Object, Object> mediaMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)mediaEntities)) {
            mediaMap = mediaEntities.stream().collect(Collectors.groupingBy(MaterialMediaEntity::getMaterialId, Collectors.mapping(o -> (MaterialMediaVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)o, MaterialMediaVo.class, HashSet.class, ArrayList.class, new String[0]), Collectors.toList())));
        }
        Map productLevelMap = productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity()));
        Map materialType = this.dictToolkitService.findMapByDictTypeCode("material_type");
        Map<Object, Object> finalMediaMap = mediaMap;
        materialVoPage.getRecords().forEach(vo -> {
            EnableStatusEnum enableStatusEnum;
            if (MapUtils.isNotEmpty((Map)materialType) && StringUtils.isNotBlank((CharSequence)vo.getMaterialType()) && materialType.containsKey(vo.getMaterialType())) {
                vo.setMaterialTypeName((String)materialType.get(vo.getMaterialType()));
            }
            if ((enableStatusEnum = EnableStatusEnum.codeToEnum((String)vo.getEnableStatus())) != null) {
                vo.setEnableStatusName(enableStatusEnum.getDes());
            }
            this.analysisSaleCompanyName((MaterialVo)vo);
            vo.setPicList((List)finalMediaMap.get(vo.getId()));
            if (StringUtils.isNotBlank((CharSequence)vo.getProductLevelCode()) && productLevelMap.containsKey(vo.getProductLevelCode())) {
                vo.setProductLevelName(((ProductLevelVo)productLevelMap.get(vo.getProductLevelCode())).getProductLevelName());
            }
        });
        return materialVoPage;
    }

    private void analysisSaleCompanyName(MaterialVo vo) {
        if (StringUtils.isBlank((CharSequence)vo.getSaleCompany())) {
            return;
        }
        vo.setSaleCompanyList((List)Lists.newArrayList((Object[])vo.getSaleCompany().split(",")));
    }

    private void analysisProductLevel(MaterialVo vo) {
        if (StringUtils.isBlank((CharSequence)vo.getProductLevelCode())) {
            return;
        }
        ProductLevelVo productLevelVo = this.productLevelVoSdkService.findDetailsByCode(vo.getProductLevelCode());
        if (productLevelVo == null) {
            return;
        }
        vo.setProductLevelName(productLevelVo.getProductLevelName());
    }

    private void analysisMaterialMedia(MaterialVo vo) {
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            return;
        }
        List<MaterialMediaEntity> materialMediaEntities = this.materialMediaRepository.findByMaterialIds(Collections.singletonList(vo.getId()));
        if (CollectionUtils.isNotEmpty(materialMediaEntities)) {
            ArrayList materialMediaVoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(materialMediaEntities, MaterialMediaEntity.class, MaterialMediaVo.class, HashSet.class, ArrayList.class, new String[0]));
            vo.setPicList((List)materialMediaVoList);
        }
    }

    public MaterialVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MaterialEntity entity = this.materialRepository.findById(id);
        if (entity == null) {
            return null;
        }
        MaterialVo materialVo = (MaterialVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, MaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.analysisSaleCompanyName(materialVo);
        this.analysisProductLevel(materialVo);
        this.analysisMaterialMedia(materialVo);
        return materialVo;
    }

    public MaterialVo findDetailByMaterialCode(String materialCode) {
        if (StringUtils.isBlank((CharSequence)materialCode)) {
            return null;
        }
        MaterialEntity entity = this.materialRepository.findDetailByMaterialCode(TenantUtils.getTenantCode(), materialCode);
        if (entity == null) {
            return null;
        }
        MaterialVo materialVo = (MaterialVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, MaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.analysisSaleCompanyName(materialVo);
        this.analysisProductLevel(materialVo);
        this.analysisMaterialMedia(materialVo);
        return materialVo;
    }

    public List<MaterialVo> findDetailByMaterialCodes(Set<String> materialCodes) {
        List levelVoList;
        if (CollectionUtils.isEmpty(materialCodes)) {
            return Lists.newArrayList();
        }
        List<MaterialEntity> entities = this.materialRepository.findDetailByMaterialCodes(TenantUtils.getTenantCode(), materialCodes);
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        Map materialType = this.dictToolkitService.findMapByDictTypeCode("material_type");
        Map<Object, Object> mapLevel = Maps.newHashMap();
        Set productLevelCodeSet = entities.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductLevelCode())).map(MaterialEntity::getProductLevelCode).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(productLevelCodeSet) && CollectionUtils.isNotEmpty((Collection)(levelVoList = this.productLevelVoSdkService.findListByCodes((List)Lists.newArrayList(productLevelCodeSet))))) {
            mapLevel = levelVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getProductLevelCode(), a.getProductLevelName()})).collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (a, b) -> a));
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, MaterialEntity.class, MaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
        List unitTypeCodes = voList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getUnitTypeCode())).map(MaterialVo::getUnitTypeCode).distinct().collect(Collectors.toList());
        MaterialUnitTypeDto materialUnitTypeDto = new MaterialUnitTypeDto();
        materialUnitTypeDto.setUnitTypeCodes(unitTypeCodes);
        List materialUnitTypeVos = this.materialUnitTypeVoService.findMaterialUnitTypeByConditions(materialUnitTypeDto);
        if (CollectionUtils.isEmpty((Collection)materialUnitTypeVos)) {
            return voList;
        }
        Map materialUnitTypeVoMap = materialUnitTypeVos.stream().collect(Collectors.toMap(MaterialUnitTypeVo::getUnitTypeCode, Function.identity()));
        for (MaterialVo o2 : voList) {
            if (StringUtils.isNotBlank((CharSequence)o2.getUnitTypeCode()) && materialUnitTypeVoMap.containsKey(o2.getUnitTypeCode())) {
                o2.setMaterialUnitTypeVo((MaterialUnitTypeVo)materialUnitTypeVoMap.get(o2.getUnitTypeCode()));
            }
            o2.setProductLevelName((String)mapLevel.get(o2.getProductLevelCode()));
            o2.setMaterialTypeName((String)materialType.get(o2.getMaterialType()));
        }
        return voList;
    }

    private void analysisSaleCompanyCode(MaterialDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getSaleCompanyList())) {
            return;
        }
        String connector = ",";
        dto.setSaleCompany(String.join((CharSequence)connector, dto.getSaleCompanyList()));
    }

    @Transactional
    public void save(MaterialDto materialDto) {
        Validate.notNull((Object)materialDto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)materialDto.getMaterialName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)materialDto.getUnitTypeCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u5355\u4f4d\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)materialDto.getMaterialCode())) {
            List codeList = this.generateCodeService.generateCode("WL", 1);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)codeList), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u751f\u6210\u7269\u6599\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
            materialDto.setMaterialCode((String)codeList.get(0));
            materialDto.setTenantCode(TenantUtils.getTenantCode());
        } else {
            MaterialEntity dbEntity = this.materialRepository.findDetailByMaterialCode(TenantUtils.getTenantCode(), materialDto.getMaterialCode());
            Validate.isTrue((boolean)Objects.isNull((Object)dbEntity), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u7f16\u7801\u5df2\u5b58\u5728\uff01", (Object[])new Object[0]);
        }
        this.analysisSaleCompanyCode(materialDto);
        MaterialEntity entity = (MaterialEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)materialDto, MaterialEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.materialRepository.save((Object)entity);
        this.materialMediaService.update(materialDto.getPicList(), entity.getId());
    }

    @Transactional
    public void update(MaterialDto materialDto) {
        Validate.notNull((Object)materialDto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)materialDto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)materialDto.getMaterialName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)materialDto.getUnitTypeCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u5355\u4f4d\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        MaterialEntity oldEntity = (MaterialEntity)((Object)this.materialRepository.getById((Serializable)((Object)materialDto.getId())));
        Validate.notNull((Object)((Object)oldEntity), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", (Object[])new Object[0]);
        this.analysisSaleCompanyCode(materialDto);
        MaterialEntity entity = (MaterialEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)materialDto, MaterialEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.materialRepository.updateById((Object)entity);
        this.materialMediaService.update(materialDto.getPicList(), entity.getId());
        if (CollectionUtils.isNotEmpty(this.materialEventListeners)) {
            MaterialVo oldVo = (MaterialVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, MaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
            MaterialVo materialVo = (MaterialVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, MaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
            MaterialEventVo materialEventVo = new MaterialEventVo();
            materialEventVo.setNewVo(materialVo);
            materialEventVo.setOldVo(oldVo);
            this.materialEventListeners.forEach(event -> event.onChange(materialEventVo));
        }
    }

    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List<MaterialEntity> entities = this.materialRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.materialRepository.updateDelFlagByIdIn(DelFlagStatusEnum.DELETE, ids);
        if (CollectionUtils.isNotEmpty(this.materialEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, MaterialEntity.class, MaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
            MaterialEventVo materialEventVo = new MaterialEventVo();
            materialEventVo.setMaterialVos(voList);
            this.materialEventListeners.forEach(event -> event.onDelete(materialEventVo));
        }
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List<MaterialEntity> entities = this.materialRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.materialRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, MaterialEntity.class, MaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
        MaterialEventVo materialEventVo = new MaterialEventVo();
        materialEventVo.setMaterialVos(voList);
        SerializableBiConsumer & Serializable sf = MaterialEventListener::onEnable;
        this.nebulaNetEventClient.publish((NebulaEventDto)materialEventVo, MaterialEventListener.class, (SerializableBiConsumer)sf);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List<MaterialEntity> entities = this.materialRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.materialRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        if (CollectionUtils.isNotEmpty(this.materialEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, MaterialEntity.class, MaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
            MaterialEventVo materialEventVo = new MaterialEventVo();
            materialEventVo.setMaterialVos(voList);
            SerializableBiConsumer & Serializable disable = MaterialEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)materialEventVo, MaterialEventListener.class, (SerializableBiConsumer)disable);
        }
    }

    public Page<MaterialVo> findByMaterialPageDto(Pageable pageable, MaterialPageDto dto) {
        List levelVoList;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (MaterialPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new MaterialPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        List productLevelCodes = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getProductLevelCodes())) {
            productLevelCodes = dto.getProductLevelCodes();
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getProductLevelType()) && CollectionUtils.isNotEmpty((Collection)(levelVoList = this.productLevelVoSdkService.findByProductLevelType(dto.getProductLevelType())))) {
            productLevelCodes.addAll(levelVoList.stream().map(ProductLevelVo::getProductLevelCode).collect(Collectors.toList()));
        }
        dto.setProductLevelCodes(productLevelCodes);
        Page<MaterialEntity> entityPage = this.materialRepository.findByMaterialPageDto(pageable, dto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        List entities = entityPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return pageResult;
        }
        pageResult.setRecords(this.covertEntityToVo(entities));
        return pageResult;
    }

    public Set<String> findCodeByProductLevelCodes(Set<String> productLevelCodeSet) {
        if (CollectionUtils.isEmpty(productLevelCodeSet)) {
            return Sets.newHashSet();
        }
        return this.materialRepository.findCodeByProductLevelCodes(productLevelCodeSet);
    }

    private List<MaterialVo> covertEntityToVo(List<MaterialEntity> entities) {
        ArrayList levelCodes = Lists.newArrayList();
        ArrayList materialIds = Lists.newArrayList();
        entities.forEach(materialEntity -> {
            if (StringUtils.isNotBlank((CharSequence)materialEntity.getProductLevelCode())) {
                levelCodes.add(materialEntity.getProductLevelCode());
            }
            materialIds.add(materialEntity.getId());
        });
        List<MaterialMediaEntity> mediaEntities = this.materialMediaRepository.findByMaterialIds(materialIds);
        Map<Object, Object> mediaMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(mediaEntities)) {
            mediaMap = mediaEntities.stream().collect(Collectors.groupingBy(MaterialMediaEntity::getMaterialId, Collectors.mapping(o -> (MaterialMediaVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)o, MaterialMediaVo.class, HashSet.class, ArrayList.class, new String[0]), Collectors.toList())));
        }
        Map levelMap = this.productLevelVoSdkService.findCurAndParentByCodes((List)levelCodes);
        ArrayList list = Lists.newArrayList();
        for (MaterialEntity materialEntity2 : entities) {
            MaterialVo vo = (MaterialVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)materialEntity2, MaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.analysisSaleCompanyName(vo);
            List productLevelVos = (List)levelMap.get(materialEntity2.getProductLevelCode());
            if (!CollectionUtils.isEmpty((Collection)productLevelVos)) {
                vo.setProductLevels(productLevelVos);
                productLevelVos.forEach(productLevelVo -> {
                    if (productLevelVo.getProductLevelCode().equals(materialEntity2.getProductLevelCode())) {
                        vo.setProductLevelName(productLevelVo.getProductLevelName());
                    }
                });
            }
            vo.setPicList((List)mediaMap.get(materialEntity2.getId()));
            list.add(vo);
        }
        return list;
    }
}

