package com.biz.crm.mdm.business.material.local.event;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.material.sdk.event.MaterialEventListener;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialEventVo;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author yangshen
 * @version 1.0
 * @date 2022/12/27 14:01
 * @ClassName MaterialEventLogListener
 * @Description TODO 物料管理日志监听
 */
@Component
public class MaterialEventLogListener implements MaterialEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 删除数据监听
     *
     * @param materialEventVo
     */
    @Override
    public void onDelete(MaterialEventVo materialEventVo) {
        List<MaterialVo> materialVos = materialEventVo.getMaterialVos();
        if (CollectionUtils.isEmpty(materialVos)) {
            return;
        }
        materialVos.forEach(materialVo -> {
            String onlyKey = materialVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(materialVo);
            crmBusinessLogDto.setNewObject(null);
            crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    /**
     * 开启数据监听
     *
     * @param materialEventVo
     */
    @Override
    public void onEnable(MaterialEventVo materialEventVo) {
        List<MaterialVo> materialVos = materialEventVo.getMaterialVos();
        if (CollectionUtils.isEmpty(materialVos)) {
            return;
        }
        materialVos.forEach(materialVo -> {
            String onlyKey = materialVo.getId();
            MaterialVo oldObj = new MaterialVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(materialVo.getEnableStatus());
            MaterialVo newObj = new MaterialVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(oldObj);
            crmBusinessLogDto.setNewObject(newObj);
            crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    /**
     * 禁用数据监听
     *
     * @param materialEventVo
     */
    @Override
    public void onDisable(MaterialEventVo materialEventVo) {
        List<MaterialVo> materialVos = materialEventVo.getMaterialVos();
        if (CollectionUtils.isEmpty(materialVos)) {
            return;
        }
        materialVos.forEach(materialVo -> {
            String onlyKey = materialVo.getId();
            MaterialVo oldObj = new MaterialVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(materialVo.getEnableStatus());
            MaterialVo newObj = new MaterialVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(oldObj);
            crmBusinessLogDto.setNewObject(newObj);
            crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    /**
     * 新建数据监听
     *
     * @param materialEventVo
     */
    @Override
    public void onCreate(MaterialEventVo materialEventVo) {
        MaterialVo newVo = materialEventVo.getNewVo();
        MaterialVo oldVo = materialEventVo.getOldVo();
        String onlyKey = newVo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(oldVo);
        crmBusinessLogDto.setNewObject(newVo);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 编辑数据监听
     *
     * @param materialEventVo
     */
    @Override
    public void onChange(MaterialEventVo materialEventVo) {
        MaterialVo newVo = materialEventVo.getNewVo();
        MaterialVo oldVo = materialEventVo.getOldVo();
        String onlyKey = newVo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(oldVo);
        crmBusinessLogDto.setNewObject(newVo);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}
