package com.biz.crm.mdm.business.material.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.mdm.business.material.local.entity.MaterialEntity;
import com.biz.crm.mdm.business.material.local.repository.MaterialRepository;
import com.biz.crm.mdm.business.material.unit.event.MaterialUnitChangeListener;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 物料单位删除事件响应
 *
 * @author jerry7
 */
@Service
public class MaterialUnitEventImpl implements MaterialUnitChangeListener {
  @Autowired(required = false)
  private MaterialRepository materialRepository;

  @Override
  public void onDelete(String unitCode) {
  }

  @Override
  public void onDeleteUnitType(String unitTypeCode) {
    LambdaQueryWrapper<MaterialEntity> wrapper = Wrappers.lambdaQuery();
    wrapper.eq(MaterialEntity::getUnitTypeCode, unitTypeCode);
    List<MaterialEntity> entities = this.materialRepository.getBaseMapper().selectList(wrapper);
    if (CollectionUtils.isNotEmpty(entities)) {
      throw new RuntimeException("此物料单位组已经被使用，无法删除！");
    }
  }
}
