/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.material.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.material.local.entity.MaterialEntity;
import com.biz.crm.mdm.business.material.local.mapper.MaterialMapper;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialDto;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialPageDto;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MaterialRepository
extends ServiceImpl<MaterialMapper, MaterialEntity> {
    public Page<MaterialVo> findByConditions(Pageable pageable, @Param(value="dto") MaterialDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MaterialDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((MaterialMapper)this.baseMapper).findByConditions((Page<MaterialEntity>)page, dto);
    }

    public List<MaterialEntity> findByIds(@Param(value="ids") List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public MaterialEntity findDetailByMaterialCode(@Param(value="tenantCode") String tenantCode, @Param(value="materialCode") String materialCode) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(MaterialEntity::getMaterialCode, (Object)materialCode);
        return (MaterialEntity)((Object)((MaterialMapper)this.baseMapper).selectOne((Wrapper)wrapper));
    }

    public List<MaterialEntity> findDetailByMaterialCodes(@Param(value="tenantCode") String tenantCode, @Param(value="materialCodes") Collection<String> materialCodes) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.in(MaterialEntity::getMaterialCode, materialCodes);
        return ((MaterialMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).in(UuidEntity::getId, ids);
        ((MaterialMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    public void updateDelFlagByIdIn(DelFlagStatusEnum delFlag, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)delFlag.getCode())).in(UuidEntity::getId, ids);
        ((MaterialMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    public MaterialEntity findById(String id) {
        return ((MaterialMapper)this.baseMapper).findById(id);
    }

    public Page<MaterialEntity> findByMaterialPageDto(Pageable pageable, MaterialPageDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((MaterialMapper)this.baseMapper).findByMaterialPageDto((Page<MaterialEntity>)page, dto);
    }

    public Set<String> findCodeByProductLevelCodes(Set<String> productLevelCodeSet) {
        return ((MaterialMapper)this.baseMapper).findCodeByProductLevelCodes(productLevelCodeSet, EnableStatusEnum.ENABLE.getCode(), DelFlagStatusEnum.NORMAL.getCode(), TenantUtils.getTenantCode());
    }
}

