package com.biz.crm.mdm.business.material.local.deprecated;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.deprecated.model.PageResult;
import com.biz.crm.mdm.business.material.sdk.deprecated.dto.MdmMaterialReqVo;
import com.biz.crm.mdm.business.material.sdk.deprecated.vo.MdmMaterialRespVo;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialDto;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * CRM2.0物料管理
 *
 * @author zxw
 * @date 2020-09-01 19:55:17
 */
@Slf4j
@RestController
@RequestMapping("/mdmMaterialController")
@Api(tags = "MDM-物料管理")
@Deprecated
public class DeprecatedMdmMaterialController {
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private MaterialVoService materialVoService;

  @ApiOperation(value = "查询分页列表")
  @PostMapping("/pageList")
  public Result<PageResult<MdmMaterialRespVo>> findByCondition(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
    try {
      Pageable pageable = PageRequest.of(mdmMaterialReqVo.getPageNum(), mdmMaterialReqVo.getPageSize());
      MaterialDto materialDto = this.nebulaToolkitService.copyObjectByWhiteList(mdmMaterialReqVo, MaterialDto.class, HashSet.class, ArrayList.class);
      Page<MaterialVo> result = materialVoService.findByConditions(pageable, materialDto);
      List<MdmMaterialRespVo> voList = Lists.newLinkedList();
      if (result.getCurrent() > 0) {
        voList = (List<MdmMaterialRespVo>) this.nebulaToolkitService.copyCollectionByWhiteList(result.getRecords(), MaterialVo.class, MdmMaterialRespVo.class, HashSet.class, ArrayList.class);
      }
      return Result.ok(PageResult.<MdmMaterialRespVo>builder()
          .data(voList)
          .count(result.getTotal())
          .build());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "详情", httpMethod = "GET")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
      @ApiImplicitParam(name = "materialCode", value = "物料编码", required = false, dataType = "String", paramType = "query")
  })
  @GetMapping("/detail")
  public Result<MdmMaterialRespVo> detail(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "materialCode", required = false) String materialCode) {
    try {
      MaterialVo materialVo = null;
      if (StringUtils.isNotBlank(id)) {
        materialVo = materialVoService.findDetailById(id);
      } else if (StringUtils.isNotBlank(materialCode)) {
        materialVo = materialVoService.findDetailByMaterialCode(materialCode);
      } else {
        return Result.error("ID或物料编码至少一个不为空！");
      }
      if (materialVo == null) {
        return Result.error("未查询到物料信息！");
      } else {
        MdmMaterialRespVo materialRespVo = this.nebulaToolkitService.copyObjectByWhiteList(materialVo, MdmMaterialRespVo.class, HashSet.class, ArrayList.class);
        return Result.ok(materialRespVo);
      }
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "新增")
  @PostMapping("/save")
  public Result<?> save(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
    try {
      MaterialDto materialDto = this.nebulaToolkitService.copyObjectByWhiteList(mdmMaterialReqVo, MaterialDto.class, HashSet.class, ArrayList.class);
      materialVoService.save(materialDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PostMapping("/update")
  public Result<?> update(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
    try {
      MaterialDto materialDto = this.nebulaToolkitService.copyObjectByWhiteList(mdmMaterialReqVo, MaterialDto.class, HashSet.class, ArrayList.class);
      materialVoService.update(materialDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "删除", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/delete")
  public Result<?> delete(@RequestBody List<String> ids) {
    try {
      materialVoService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "启用", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      materialVoService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "禁用", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      materialVoService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "物料下拉框")
  @PostMapping("/materialSelect")
  public Result<List<MdmMaterialRespVo>> materialSelect(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
    try {
      Pageable pageable = PageRequest.of(mdmMaterialReqVo.getPageNum(), mdmMaterialReqVo.getPageSize());
      MaterialDto materialDto = this.nebulaToolkitService.copyObjectByWhiteList(mdmMaterialReqVo, MaterialDto.class, HashSet.class, ArrayList.class);
      Page<MaterialVo> result = materialVoService.findByConditions(pageable, materialDto);
      List<MdmMaterialRespVo> voList = Lists.newLinkedList();
      if (result.getCurrent() > 0) {
        voList = (List<MdmMaterialRespVo>) this.nebulaToolkitService.copyCollectionByWhiteList(result.getRecords(), MaterialVo.class, MdmMaterialRespVo.class, HashSet.class, ArrayList.class);
      }
      return Result.ok(voList);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "物料下拉框（只查询启用的）")
  @PostMapping("/materialSelectEnable")
  public Result<List<MdmMaterialRespVo>> materialSelectEnable(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
    try {
      mdmMaterialReqVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
      return this.materialSelect(mdmMaterialReqVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
