package com.biz.crm.mdm.business.material.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @ClassName MaterialRelationWarehouseEntity
 * @Description 物料关联仓库
 * @AUTHOR WangJJ
 * @DATE 2023/6/25 11:33
 **/
@Data
@ApiModel(value = "MaterialMediaEntity", description = "物料关联仓库")
@Entity
@Table(name = "mdm_material_relation_warehouse")
@TableName(value = "mdm_material_relation_warehouse")
@org.hibernate.annotations.Table(appliesTo = "mdm_material_relation_warehouse", comment = "物料关联仓库")
public class MaterialRelationWarehouseEntity extends TenantFlagOpEntity {


    /**
     * 物料id
     */
    @ApiModelProperty(name = "material_id", value = "物料id", required = true)
    @Column(name = "material_id", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '物料id'")
    private String materialId;

    /**
     * 仓库ID
     */
    @ApiModelProperty(value = "仓库ID")
    @Column(name = "warehouse_id", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '仓库ID'")
    private String warehouseId;

    /**
     * 箱数
     */
    @ApiModelProperty(value = "箱数")
    @Column(name = "number", length = 20, columnDefinition = "int COMMENT '箱数'")
    private Integer number;


}
