package com.biz.crm.mdm.business.material.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.material.local.entity.MaterialMediaEntity;
import com.biz.crm.mdm.business.material.local.mapper.MaterialMediaMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 物料图片表的数据库访问类 {@link MaterialMediaEntity}
 *
 * @author ning.zhang
 * @date 2021-12-13 10:26:03
 */
@Component
public class MaterialMediaRepository extends ServiceImpl<MaterialMediaMapper, MaterialMediaEntity> {


  /**
   * 通过物料ID删除公告文件信息
   *
   * @param materialId 物料ID
   */
  public void deleteByMaterialId(String materialId) {
    this.lambdaUpdate()
        .eq(MaterialMediaEntity::getTenantCode, TenantUtils.getTenantCode())
        .eq(MaterialMediaEntity::getMaterialId, materialId)
        .remove();
  }

  /**
   * 通过物料ID集合获取物料文件信息
   *
   * @param materialIds 物料ID集合
   * @return 物料文件信息
   */
  public List<MaterialMediaEntity> findByMaterialIds(List<String> materialIds) {
    return this.lambdaQuery()
        .eq(MaterialMediaEntity::getTenantCode, TenantUtils.getTenantCode())
        .in(MaterialMediaEntity::getMaterialId, materialIds)
        .list();
  }
}
