package com.biz.crm.mdm.business.material.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.material.local.entity.MaterialRelationWarehouseEntity;
import com.biz.crm.mdm.business.material.local.mapper.MaterialRelationWarehouseMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName MaterialRelationWarehouseRepository
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/25 11:36
 **/
@Component
public class MaterialRelationWarehouseRepository extends ServiceImpl<MaterialRelationWarehouseMapper, MaterialRelationWarehouseEntity> {

    public List<MaterialRelationWarehouseEntity> listByMaterialsId(String materialsId){
        if (StringUtils.isEmpty(materialsId)){
            return Lists.newArrayList();
        }
        List<MaterialRelationWarehouseEntity> list = this.lambdaQuery()
                .eq(MaterialRelationWarehouseEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(MaterialRelationWarehouseEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(MaterialRelationWarehouseEntity::getMaterialId, materialsId)
                .list();
        if (CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        return list;
    }

    public void removeByMaterialsId(String materialsId){
        if (StringUtils.isEmpty(materialsId)){
            return;
        }
        this.lambdaUpdate()
                .eq(MaterialRelationWarehouseEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(MaterialRelationWarehouseEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(MaterialRelationWarehouseEntity::getMaterialId, materialsId)
                .remove();
    }

    public void removeByMaterialsIds(List<String> materialsIds){
        if (CollectionUtils.isEmpty(materialsIds)){
            return;
        }
        this.lambdaUpdate()
                .eq(MaterialRelationWarehouseEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(MaterialRelationWarehouseEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(MaterialRelationWarehouseEntity::getMaterialId, materialsIds)
                .remove();
    }



}
