/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.material.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialDto;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialPageDto;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialSearchDto;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/v1/material/material"})
@RestController
@Api(tags={"\u7269\u6599\u7ba1\u7406\uff1aMaterialVo\uff1a\u7269\u6599\u7ba1\u7406"})
public class MaterialVoController {
    private static final Logger log = LoggerFactory.getLogger(MaterialVoController.class);
    @Autowired(required=false)
    private MaterialVoService materialVoService;

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7269\u6599\u4fe1\u606f", httpMethod="GET")
    @GetMapping(value={"/findAll"})
    public Result<List<MaterialVo>> findAll() {
        try {
            List result = this.materialVoService.findAll();
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868", httpMethod="GET")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<MaterialVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, MaterialDto materialDto) {
        try {
            Page result = this.materialVoService.findByConditions(pageable, materialDto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u8be6\u60c5", httpMethod="GET")
    @GetMapping(value={"/findDetailById"})
    public Result<MaterialVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            return Result.ok((Object)this.materialVoService.findDetailById(id));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7269\u6599\u7f16\u7801\u67e5\u8be2\u8be6\u60c5", httpMethod="GET")
    @GetMapping(value={"/findDetailByMaterialCode"})
    public Result<MaterialVo> findDetailByMaterialCode(@RequestParam(value="materialCode") String materialCode) {
        try {
            return Result.ok((Object)this.materialVoService.findDetailByMaterialCode(materialCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7269\u6599\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u8be6\u60c5", httpMethod="GET")
    @GetMapping(value={"/findDetailByMaterialCodes"})
    public Result<List<MaterialVo>> findDetailByMaterialCodes(@RequestParam(value="materialCodes") Set<String> materialCodes) {
        try {
            return Result.ok((Object)this.materialVoService.findDetailByMaterialCodes(materialCodes));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e", httpMethod="POST")
    @PostMapping
    public Result<?> create(@RequestBody MaterialDto materialDto) {
        try {
            this.materialVoService.save(materialDto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0", httpMethod="PATCH")
    @PatchMapping
    public Result<?> update(@RequestBody MaterialDto materialDto) {
        try {
            this.materialVoService.update(materialDto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="DELETE")
    @DeleteMapping
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.materialVoService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="PATCH")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.materialVoService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="PATCH")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.materialVoService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u7269\u6599\u6570\u636e\u5206\u9875\u4fe1\u606f", httpMethod="GET")
    @GetMapping(value={"/findByMaterialPageDto"})
    public Result<Page<MaterialVo>> findByMaterialPageDto(@PageableDefault(value=50) Pageable pageable, MaterialPageDto dto) {
        try {
            Page result = this.materialVoService.findByMaterialPageDto(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4ea7\u54c1\u5c42\u7ea7\u83b7\u53d6\u542f\u7528\u7684\u672a\u5220\u9664\u7684\u7269\u6599\u7f16\u7801\u96c6\u5408")
    @PostMapping(value={"/findCodeByProductLevelCodes"})
    public Result<Set<String>> findCodeByProductLevelCodes(@RequestBody Set<String> productLevelCodeSet) {
        try {
            return Result.ok((Object)this.materialVoService.findCodeByProductLevelCodes(productLevelCodeSet));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eids\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u7269\u6599\u4fe1\u606f")
    @PostMapping(value={"/findMaterialByIds"})
    public Result<List<MaterialVo>> findMaterialByIds(@RequestBody MaterialSearchDto dto) {
        try {
            List list = this.materialVoService.findMaterialByIds(dto);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

