/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.material.local.event;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.material.sdk.event.MaterialEventListener;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialEventVo;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MaterialEventLogListener
implements MaterialEventListener {
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    public void onDelete(MaterialEventVo materialEventVo) {
        List materialVos = materialEventVo.getMaterialVos();
        if (CollectionUtils.isEmpty((Collection)materialVos)) {
            return;
        }
        materialVos.forEach(materialVo -> {
            String onlyKey = materialVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(materialVo);
            crmBusinessLogDto.setNewObject(null);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    public void onEnable(MaterialEventVo materialEventVo) {
        List materialVos = materialEventVo.getMaterialVos();
        if (CollectionUtils.isEmpty((Collection)materialVos)) {
            return;
        }
        materialVos.forEach(materialVo -> {
            String onlyKey = materialVo.getId();
            MaterialVo oldObj = new MaterialVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(materialVo.getEnableStatus());
            MaterialVo newObj = new MaterialVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject((Object)oldObj);
            crmBusinessLogDto.setNewObject((Object)newObj);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    public void onDisable(MaterialEventVo materialEventVo) {
        List materialVos = materialEventVo.getMaterialVos();
        if (CollectionUtils.isEmpty((Collection)materialVos)) {
            return;
        }
        materialVos.forEach(materialVo -> {
            String onlyKey = materialVo.getId();
            MaterialVo oldObj = new MaterialVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(materialVo.getEnableStatus());
            MaterialVo newObj = new MaterialVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject((Object)oldObj);
            crmBusinessLogDto.setNewObject((Object)newObj);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    public void onCreate(MaterialEventVo materialEventVo) {
        MaterialVo newVo = materialEventVo.getNewVo();
        MaterialVo oldVo = materialEventVo.getOldVo();
        String onlyKey = newVo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)oldVo);
        crmBusinessLogDto.setNewObject((Object)newVo);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onChange(MaterialEventVo materialEventVo) {
        MaterialVo newVo = materialEventVo.getNewVo();
        MaterialVo oldVo = materialEventVo.getOldVo();
        String onlyKey = newVo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)oldVo);
        crmBusinessLogDto.setNewObject((Object)newVo);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}

