/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.material.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.material.local.entity.MaterialRelationWarehouseEntity;
import com.biz.crm.mdm.business.material.local.mapper.MaterialRelationWarehouseMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class MaterialRelationWarehouseRepository
extends ServiceImpl<MaterialRelationWarehouseMapper, MaterialRelationWarehouseEntity> {
    public List<MaterialRelationWarehouseEntity> listByMaterialsId(String materialsId) {
        if (StringUtils.isEmpty((CharSequence)materialsId)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(MaterialRelationWarehouseEntity::getMaterialId, (Object)materialsId)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public void removeByMaterialsId(String materialsId) {
        if (StringUtils.isEmpty((CharSequence)materialsId)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(MaterialRelationWarehouseEntity::getMaterialId, (Object)materialsId)).remove();
    }

    public void removeByMaterialsIds(List<String> materialsIds) {
        if (CollectionUtils.isEmpty(materialsIds)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(MaterialRelationWarehouseEntity::getMaterialId, materialsIds)).remove();
    }
}

