package com.biz.crm.mdm.business.material.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 物料dto
 *
 * @author pengxi
 * @date 2021-09-27 14:44:10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "物料dto")
public class MaterialDto extends TenantFlagOpDto {

  /**
   * 产品层级编码集合
   */
  @ApiModelProperty("产品层级编码集合")
  private List<String> productLevelCodes;

  /**
   * 产品层级编码
   */
  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;

  /**
   * 物料名称
   */
  @ApiModelProperty("物料名称")
  private String materialName;

  /**
   * AI编码
   */
  @ApiModelProperty("AI编码")
  private String aiCode;

  /**
   * 条形码
   */
  @ApiModelProperty("条形码")
  private String barCode;

  /**
   * 物料类型
   */
  @ApiModelProperty("物料类型")
  private String materialType;

  /**
   * 销售公司编码（列表显示用）。多个编码用逗号隔开
   */
  @ApiModelProperty("销售公司编码（列表显示用）。多个编码用逗号隔开")
  private String saleCompany;

  /**
   * 销售公司（新增入参和编辑回传）
   */
  @ApiModelProperty("销售公司（新增入参和编辑回传）")
  private List<String> saleCompanyList;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String specification;

  /**
   * 成本价格
   */
  @ApiModelProperty("成本价格")
  private String costPrice;

  /**
   * 毛重
   */
  @ApiModelProperty("毛重")
  private String grossWeight;

  /**
   * 净重
   */
  @ApiModelProperty("净重")
  private String netWeight;

  /**
   * 容量
   */
  @ApiModelProperty("容量")
  private String capacity;

  /**
   * 规则编码
   */
  @ApiModelProperty("规则编码")
  private String ruleCode;

  /**
   * 开始时间
   */
  @ApiModelProperty(name = "startTime", value = "开始时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date startTime;

  /**
   * 结束时间
   */
  @ApiModelProperty(name = "endTime", value = "结束时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date endTime;

  /**
   * 物料单位类型编码
   */
  @ApiModelProperty("物料单位类型编码")
  private String unitTypeCode;

  /**
   * 标准单位
   */
  @ApiModelProperty("标准单位")
  private String standardUnit;

  /**
   * 单位名称
   */
  @ApiModelProperty("单位名称")
  private String unitConversion;

  /**
   * 盒码单位转换系数
   */
  @ApiModelProperty("盒码单位转换系数")
  private BigDecimal boxUnitConversion;

  /**
   * 箱码单位转换系数
   */
  @ApiModelProperty("箱码单位转换系数")
  private BigDecimal caseUnitConversion;

  /**
   * 图片信息
   */
  @ApiModelProperty("图片信息")
  private List<MaterialMediaDto> picList;

  /**
   * 用于下拉列表选择,输入回显编码集合，字符串集合，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据
   */
  @ApiModelProperty("用于下拉列表选择,输入回显编码集合，字符串集合，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
  private List<String> selectedCode;

}