package com.biz.crm.mdm.business.material.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 物料分页请求Dto
 *
 * @author ning.zhang
 * @date 2022/2/22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "物料分页请求Dto")
public class MaterialPageDto extends TenantFlagOpDto {

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;
  /**
   * 物料名称
   */
  @ApiModelProperty("物料名称")
  private String materialName;
  /**
   * 商品层级编码
   * <pre>
   *   "brand":"品牌"
   *   "series":"系列"
   *   "max":"大类"
   *   "min":"细类"
   * </pre>
   */
  @ApiModelProperty("商品层级类型")
  private String productLevelType;
  /**
   * 商品层级编码集合
   */
  @ApiModelProperty("商品层级编码集合")
  private List<String> productLevelCodes;

  /**
   * 物料编码集合
   */
  @ApiModelProperty("物料编码集合")
  private List<String> materialCodes;

  /**
   * 修改开始时间
   */
  @ApiModelProperty("修改开始时间")
  private String modifyStartDate;

  /**
   * 修改结束时间
   */
  @ApiModelProperty("修改结束时间")
  private String modifyEndDate;

}