package com.biz.crm.mdm.business.material.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialDto;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialPageDto;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.google.common.collect.Sets;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * 物料接口
 *
 * @author pengxi
 * @date 2021-09-27 14:44:10
 */
public interface MaterialVoService {

  /**
   * 列表
   * TODO 需要关联查询产品层级表的rule_code字段，所以考虑改为报表实现
   * @param pageable 分页
   * @param materialDto 条件
   * @return Page
   */
  Page<MaterialVo> findByConditions(Pageable pageable, MaterialDto materialDto);

  /**
   * 根据ID获取物料详情
   *
   * @param id
   * @return
   */
  MaterialVo findDetailById(String id);

  /**
   * 根据物料编码获取详情
   *
   * @param materialCode 物料编码
   * @return
   */
  MaterialVo findDetailByMaterialCode(String materialCode);

  /**
   * 根据物料编码集合获取详情
   *
   * @param materialCodes 物料编码集合
   * @return
   */
  List<MaterialVo> findDetailByMaterialCodes(Set<String> materialCodes);

  /**
   * 新增
   *
   * @param materialDto 新增实例
   */
  void save(MaterialDto materialDto);

  /**
   * 更新
   *
   * @param materialDto 更新实例
   */
  void update(MaterialDto materialDto);

  /**
   * 删除
   *
   * @param ids id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 启用
   *
   * @param ids id集合
   */
  void enableBatch(List<String> ids);

  /**
   * 禁用
   *
   * @param ids id集合
   */
  void disableBatch(List<String> ids);

  /**
   * 获取物料数据分页信息
   *
   * @param pageable 分页信息
   * @param dto 请求参数
   * @return 物料数据分页信息
   */
  default Page<MaterialVo> findByMaterialPageDto(Pageable pageable, MaterialPageDto dto) {
    return null;
  }

  /**
   * 根据商品层级编码集合获取对应层级及子级对应的物料编码集合
   *
   * @param productLevelCodeSet
   * @return
   */
  default Set<String> findCodeByProductLevelCodes(Set<String> productLevelCodeSet) {
    return Sets.newHashSet();
  }
}

