package com.biz.crm.mdm.business.material.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.mdm.business.material.unit.vo.MaterialUnitTypeVo;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 物料vo
 *
 * @author pengxi
 * @date 2021-09-27 14:44:10
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "MaterialVo", description = "物料vo")
public class MaterialVo extends TenantFlagOpVo {
  private static final long serialVersionUID = 4433325597448264619L;

  /**
   * 产品层级编码
   */
  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  /**
   * 产品层级名称
   */
  @ApiModelProperty("产品层级名称")
  private String productLevelName;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;

  /**
   * 产品名称
   */
  @ApiModelProperty("产品名称")
  private String materialName;

  /**
   * ai编码
   */
  @ApiModelProperty("ai编码")
  private String aiCode;

  /**
   * 条形码
   */
  @ApiModelProperty("条形码")
  private String barCode;

  /**
   * 物料类型
   */
  @ApiModelProperty("物料类型")
  private String materialType;

  /**
   * 物料类型名称
   */
  @ApiModelProperty("物料类型名称")
  private String materialTypeName;

  /**
   * 销售公司编码（列表显示用）。多个编码用逗号隔开
   */
  @ApiModelProperty("销售公司编码（列表显示用）。多个编码用逗号隔开")
  private String saleCompany;

  /**
   * 销售公司编码集合
   */
  @ApiModelProperty("销售公司（新增入参和编辑回传）")
  private List<String> saleCompanyList;

  /**
   * 销售公司编码（列表显示用）。多个名称用逗号隔开
   */
  @ApiModelProperty("销售公司编码（列表显示用）。多个名称用逗号隔开")
  private String saleCompanyName;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String specification;

  /**
   * 成本价格
   */
  @ApiModelProperty("成本价格")
  private String costPrice;

  /**
   * 毛重
   */
  @ApiModelProperty("毛重")
  private String grossWeight;

  /**
   * 净重
   */
  @ApiModelProperty("净重")
  private String netWeight;

  /**
   * 容量
   */
  @ApiModelProperty("容量")
  private String capacity;

  /**
   * 标准单位
   */
  @ApiModelProperty("标准单位")
  private String standardUnit;

  /**
   * 单位名称
   */
  @ApiModelProperty("单位名称")
  private String unitConversion;

  /**
   * 盒码单位转算系数
   */
  @ApiModelProperty("盒码单位转算系数")
  private BigDecimal boxUnitConversion;

  /**
   * 箱码单位转算系数
   */
  @ApiModelProperty("箱码单位转算系数")
  private BigDecimal caseUnitConversion;

  /**
   * 启禁用状态名称
   */
  @ApiModelProperty("启禁用状态名称")
  private String enableStatusName;

  /**
   * 物料单位类型编码
   */
  @ApiModelProperty("物料单位类型编码")
  private String unitTypeCode;

  /**
   * 物料单位类型VO
   */
  @ApiModelProperty("物料单位类型VO")
  private MaterialUnitTypeVo materialUnitTypeVo;

  /**
   * 图片信息
   */
  @ApiModelProperty("图片信息")
  private List<MaterialMediaVo> picList;

  /**
   * 层级集合 （指本商品所属层级 所有父节点的信息 包括自己）
   */
  @ApiModelProperty("层级集合")
  private List<ProductLevelVo> productLevels;
}